package com.cerve.development.ui.canvas.operators

import androidx.compose.runtime.Composable
import androidx.compose.runtime.saveable.Saver
import androidx.compose.runtime.saveable.listSaver
import androidx.compose.runtime.saveable.rememberSaveable
import com.cerve.development.ui.canvas.model.CerveCanvasInteractionType
import com.cerve.development.ui.canvas.model.CerveDrawCanvasState
import com.cerve.development.ui.canvas.model.CerveLine
import kotlinx.serialization.json.Json

val CerveDrawCanvasStateSaver: Saver<CerveDrawCanvasState, *> = listSaver(
    save = { state ->
        val saverJson = Json { coerceInputValues = true }

        listOf<String>(
            saverJson.encodeToString(state.initialLines),
            saverJson.encodeToString(state.interactionType),
            saverJson.encodeToString(state.historyLines.toList()),
            saverJson.encodeToString(state.currentLines.toList()),
            saverJson.encodeToString(state.currentLineCandidates.toList()),
            saverJson.encodeToString(state.initialScale),
        )
    },
    restore = { list ->
        val saverJson = Json { coerceInputValues = true }

        CerveDrawCanvasState(
            initialLines = saverJson.decodeFromString<List<CerveLine>>(list[0]),
            initialScale = saverJson.decodeFromString<Float>(list[5])
        ).apply {
            onChangeInteractionType(saverJson.decodeFromString<CerveCanvasInteractionType>(list[1]))

            val historyCandidate = saverJson.decodeFromString<List<CerveLine>>(list[2])
            historyLines.addAll(historyCandidate)

            val currentLinesCandidate = saverJson.decodeFromString<List<CerveLine>>(list[3])
            currentLines.addAll(currentLinesCandidate)

            val currentLineCandidatesCandidate = saverJson.decodeFromString<List<CerveLine>>(list[4])
            currentLineCandidates.addAll(currentLineCandidatesCandidate)
        }
    }
)

@Composable
fun rememberCerveDrawCanvasState(
    initial: List<CerveLine> = emptyList(),
    initialScale: Float = 1f
) : CerveDrawCanvasState {
    return rememberSaveable(saver = CerveDrawCanvasStateSaver) {
        CerveDrawCanvasState(
            initialLines = initial,
            initialScale = initialScale
        )
    }
}