package com.cerve.development.ui.canvas.operators

import androidx.compose.runtime.MutableState
import androidx.compose.ui.Modifier
import androidx.compose.ui.layout.onSizeChanged
import androidx.compose.ui.unit.toSize
import com.cerve.development.ui.canvas.model.CerveCanvasSize

fun Modifier.canvasSizeChange(
    onSizeChange: (CerveCanvasSize) -> Unit
) = this.then(Modifier
    .onSizeChanged { newSize -> onSizeChange(CerveCanvasSize(newSize.toSize())) })


fun Modifier.canvasSizeChange(
    size: MutableState<CerveCanvasSize>
) = this.then(Modifier
    .onSizeChanged { newSize -> size.value = (CerveCanvasSize(newSize.toSize())) })