package com.cerve.development.ui.canvas.model

import kotlinx.serialization.Serializable
import kotlin.math.roundToInt

@Serializable
data class CerveCanvasGridProperties(
    val size: CerveSize,
    val gridLineCount: Int
) {

    val translationAmount = size.center
    val gridSpacing = size.spacing(gridLineCount)
        .roundToInt()

    fun gridLine(step: Int) : CerveGridLinePair {

        val stepOffset = (step * gridSpacing).toFloat()

        val xStart = CerveOffset(x = stepOffset, y = 0f)
        val xEnd = CerveOffset(x = stepOffset, y = size.span)

        val xLine = CerveLine(start = xStart, end = xEnd)

        val yStart = CerveOffset(x = 0f, y = stepOffset)
        val yEnd = CerveOffset(x = size.span, y = stepOffset)

        val yLine = CerveLine(start = yStart, end = yEnd)

        return CerveGridLinePair(xLine = xLine, yLine = yLine)
    }

    fun translatedGridLine(step: Int) : CerveGridLinePair {

        val stepOffset = step * gridSpacing
        val xStepOffset = stepOffset + size.center.x
        val yStepOffset = stepOffset + size.center.y

        val xStart = CerveOffset(x = xStepOffset, y = size.center.y)
        val xEnd = CerveOffset(x = xStepOffset, y = size.center.y + size.span)

        val xLine = CerveLine(start = xStart, end = xEnd)

        val yStart = CerveOffset(x = size.center.x, y = yStepOffset)
        val yEnd = CerveOffset(x = size.center.x + size.span, y = yStepOffset)

        val yLine = CerveLine(start = yStart, end = yEnd)

        return CerveGridLinePair(xLine = xLine, yLine = yLine)
    }
}
