package com.cerve.development.ui.canvas.operators

import androidx.compose.foundation.layout.BoxWithConstraintsScope
import androidx.compose.runtime.Composable
import androidx.compose.runtime.remember
import androidx.compose.runtime.saveable.Saver
import androidx.compose.runtime.saveable.listSaver
import androidx.compose.runtime.saveable.rememberSaveable
import androidx.compose.ui.platform.LocalDensity
import com.cerve.development.ui.canvas.model.CerveCanvasGridProperties
import com.cerve.development.ui.canvas.model.CerveDrawCanvasState
import com.cerve.development.ui.canvas.model.CerveLine
import com.cerve.development.ui.canvas.model.CerveSize
import kotlinx.serialization.json.Json

val CerveDrawCanvasStateSaver: Saver<CerveDrawCanvasState, *> = listSaver(
    save = { state ->
        val saverJson = Json { coerceInputValues = true }
        val state = saverJson.encodeToString<CerveDrawCanvasState>(state)
        listOf(state)
    },
    restore = { list ->
        val saverJson = Json { coerceInputValues = true }
        saverJson.decodeFromString<CerveDrawCanvasState>(list[0])
    }
)

@Composable
fun rememberCerveDrawCanvasState(
    initial: List<CerveLine> = emptyList(),
    initialScale: Float = 1f
) : CerveDrawCanvasState {
    return rememberSaveable(saver = CerveDrawCanvasStateSaver) {
        CerveDrawCanvasState(
            initialLines = initial,
            initialScale = initialScale
        )
    }
}

@Composable
fun BoxWithConstraintsScope.rememberCanvasGridProperties(
    gridLineCount: Int
) : CerveCanvasGridProperties {

    val canvasSize = LocalDensity.current.run {
        CerveSize(width = maxWidth.toPx(), height = maxHeight.toPx())
    }
    return remember {
        CerveCanvasGridProperties(
            size = canvasSize,
            gridLineCount = gridLineCount
        )
    }
}