package com.cerve.development.ui.canvas.operators

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.drawscope.DrawScope
import androidx.compose.ui.graphics.drawscope.Fill
import androidx.compose.ui.graphics.drawscope.translate
import androidx.compose.ui.unit.Dp
import com.cerve.development.ui.canvas.model.CerveLine
import com.cerve.development.ui.canvas.model.CerveOffset

fun DrawScope.canvasScope(
    strokeWidth: Dp,
    eraserColor: Color,
    eraserRadius: Float,
    eraserCenter: () -> CerveOffset?,
    lineColor: Color,
    currentLines: MutableList<CerveLine>,
    candidateLineColor: Color,
    currentLineCandidates: MutableList<CerveLine>,
    translationAmount: CerveOffset,
    scope: DrawScope.() -> Unit = { }
) {

    translate(left = translationAmount.x, top = translationAmount.y) {
        currentLineCandidates.forEach { line ->
            drawLine(
                color = candidateLineColor,
                start = line.start.offset,
                end = line.end.offset,
                strokeWidth = strokeWidth.toPx(),
                cap = StrokeCap.Round
            )
        }

        currentLines.forEach { line ->
            drawLine(
                color = lineColor,
                start = line.start.offset,
                end = line.end.offset,
                strokeWidth = strokeWidth.toPx(),
                cap = StrokeCap.Round
            )
        }

        eraserCenter()?.let { eraserCenter ->
            drawCircle(
                color = eraserColor,
                center = eraserCenter.offset,
                radius = eraserRadius,
                style = Fill
            )
        }

        scope()
    }
}