package com.cerve.development.ui.canvas.model

import androidx.compose.ui.geometry.Offset
import com.cerve.development.ui.canvas.model.CerveOffset.Companion.offset
import kotlinx.serialization.Serializable

@Serializable
data class CerveLine(
    val start: CerveOffset,
    val end: CerveOffset
) {

    fun plus(value: Offset) : CerveLine {
        return CerveLine(
            start = (start.offset + value).offset,
            end = (end.offset + value).offset
        )
    }

    fun adjust(center: Offset, calculatedCenter: CerveOffset) : CerveLine {
        val offset = center.minus(calculatedCenter.offset)
            .div(2f)

        return copy(
            start = (start.offset + offset).offset,
            end = (end.offset + offset).offset
        )
    }

    companion object {
        val Zero = CerveLine(
            start = CerveOffset.Zero,
            end = CerveOffset.Zero
        )

        fun defaultCerveLine(
            start: CerveOffset,
            end: CerveOffset
        ) = CerveLine(
            start = start,
            end = end
        )
    }
}
