package com.cerve.development.ui.canvas.component

import androidx.compose.foundation.Canvas
import androidx.compose.foundation.layout.BoxWithConstraints
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.drawscope.DrawScope
import androidx.compose.ui.unit.Dp
import com.cerve.development.ui.canvas.model.CerveCanvasGridProperties
import com.cerve.development.ui.canvas.model.CerveCanvasInteractionType
import com.cerve.development.ui.canvas.model.CerveCell
import com.cerve.development.ui.canvas.model.CerveLine
import com.cerve.development.ui.canvas.model.CerveOffset
import com.cerve.development.ui.canvas.operators.canvasInput
import com.cerve.development.ui.canvas.operators.canvasScope
import com.cerve.development.ui.canvas.operators.changeOrientation
import com.cerve.development.ui.canvas.operators.drawGrid
import com.cerve.development.ui.canvas.operators.rememberCanvasGridProperties
import com.cerve.development.ui.canvas.operators.zoomInput

@Composable
private fun CerveDefaultCanvas(
    strokeWidth: Dp,
    gridColor: Color,
    gridLineCount: Int,
    showGridLine: Boolean,
    currentLines: MutableList<CerveLine>,
    currentLineCandidates: MutableList<CerveLine>,
    selectedGridCells: MutableList<CerveCell>,
    eraserRadius: Float,
    modifier: Modifier = Modifier,
    eraserColor: Color = Color.Gray.copy(0.4f),
    lineColor: Color = Color.Black,
    candidateLineColor: Color = Color.LightGray,
    gridCellColor: Color = Color.Green,
    eraserCenter: () -> CerveOffset?,
    interactionType: () -> CerveCanvasInteractionType?,
    transformationScale: () -> Float,
    transformationRotation: () -> Float,
    translationAmount: () -> CerveOffset,
    onChangeEraserCenter: (CerveOffset?) -> Unit,
    onChangeTransformationScale: (Float?) -> Unit,
    onChangeTransformationRotation: (Float?) -> Unit,
    onChangeTransformationOffset: (CerveOffset?) -> Unit,
    onResetTransformations: () -> Unit,
    onDrawScope: DrawScope.(Color, CerveCanvasGridProperties) -> Unit
) {

    BoxWithConstraints(modifier = modifier) {

        val properties = rememberCanvasGridProperties(gridLineCount)

        Canvas(
            modifier = Modifier
                .matchParentSize()
                .changeOrientation(
                    scale = transformationScale,
                    rotation = transformationRotation,
                    offset = translationAmount
                ).zoomInput(
                    interactionType = interactionType,
                    transformationScale = transformationScale,
                    transformationRotation = transformationRotation,
                    translationAmount = translationAmount,
                    onChangeTransformationScale = onChangeTransformationScale,
                    onChangeTransformationRotation = onChangeTransformationRotation,
                    onChangeTransformationOffset = onChangeTransformationOffset,
                    onResetTransformations = onResetTransformations
                ).drawGrid(
                    color = gridColor,
                    properties = properties,
                    showGridLine = showGridLine
                ).canvasInput(
                    interactionType = interactionType,
                    gridSpacing = properties.gridSpacing,
                    eraserCenter = eraserCenter,
                    eraserRadius = eraserRadius,
                    currentLines = currentLines,
                    currentLineCandidates = currentLineCandidates,
                    translationAmount = properties.size.center,
                    onChangeEraserCenter = onChangeEraserCenter
                )
        ) {
            canvasScope(
                strokeWidth = strokeWidth,
                eraserColor = eraserColor,
                eraserRadius = eraserRadius,
                eraserCenter = eraserCenter,
                lineColor = lineColor,
                gridCellColor = gridCellColor,
                currentLines = currentLines,
                candidateLineColor = candidateLineColor,
                currentLineCandidates = currentLineCandidates,
                currentSelectedCells = selectedGridCells,
                translationAmount = properties.size.center,
                scope = { onDrawScope(lineColor, properties) }
            )
        }
    }

}

@Composable
fun CerveCanvas(
    strokeWidth: Dp,
    gridColor: Color,
    gridLineCount: Int,
    showGridLine: Boolean,
    currentLines: MutableList<CerveLine>,
    currentLineCandidates: MutableList<CerveLine>,
    selectedGridCells: MutableList<CerveCell>,
    eraserRadius: Float,
    modifier: Modifier = Modifier,
    eraserColor: Color = Color.Gray.copy(0.4f),
    lineColor: Color = Color.Black,
    candidateLineColor: Color = Color.LightGray,
    eraserCenter: () -> CerveOffset?,
    interactionType: () -> CerveCanvasInteractionType?,
    transformationScale: () -> Float,
    transformationRotation: () -> Float,
    translationAmount: () -> CerveOffset,
    onChangeEraserCenter: (CerveOffset?) -> Unit,
    onChangeTransformationScale: (Float?) -> Unit,
    onChangeTransformationRotation: (Float?) -> Unit,
    onChangeTransformationOffset: (CerveOffset?) -> Unit,
    onResetTransformations: () -> Unit
) = CerveDefaultCanvas(
    strokeWidth = strokeWidth,
    gridColor = gridColor,
    gridLineCount = gridLineCount,
    showGridLine = showGridLine,
    currentLines = currentLines,
    currentLineCandidates = currentLineCandidates,
    selectedGridCells = selectedGridCells,
    eraserRadius = eraserRadius,
    modifier = modifier,
    eraserColor = eraserColor,
    lineColor = lineColor,
    candidateLineColor = candidateLineColor,
    eraserCenter = eraserCenter,
    interactionType = interactionType,
    transformationScale = transformationScale,
    transformationRotation = transformationRotation,
    translationAmount = translationAmount,
    onChangeEraserCenter = onChangeEraserCenter,
    onChangeTransformationScale = onChangeTransformationScale,
    onChangeTransformationRotation = onChangeTransformationRotation,
    onChangeTransformationOffset = onChangeTransformationOffset,
    onResetTransformations = onResetTransformations,
    onDrawScope = { _, _, ->  }
)

@Composable
fun CerveCanvasScope(
    strokeWidth: Dp,
    gridColor: Color,
    gridLineCount: Int,
    showGridLine: Boolean,
    currentLines: MutableList<CerveLine>,
    currentLineCandidates: MutableList<CerveLine>,
    currentSelectedCells: MutableList<CerveCell>,
    eraserRadius: Float,
    modifier: Modifier = Modifier,
    eraserColor: Color = Color.Gray.copy(0.4f),
    lineColor: Color = Color.Black,
    candidateLineColor: Color = Color.LightGray,
    eraserCenter: () -> CerveOffset?,
    interactionType: () -> CerveCanvasInteractionType?,
    transformationScale: () -> Float,
    transformationRotation: () -> Float,
    translationAmount: () -> CerveOffset,
    onChangeEraserCenter: (CerveOffset?) -> Unit,
    onChangeTransformationScale: (Float?) -> Unit,
    onChangeTransformationRotation: (Float?) -> Unit,
    onChangeTransformationOffset: (CerveOffset?) -> Unit,
    onResetTransformations: () -> Unit,
    onDrawScope: DrawScope.(Color, CerveCanvasGridProperties) -> Unit
) = CerveDefaultCanvas(
    strokeWidth = strokeWidth,
    gridColor = gridColor,
    gridLineCount = gridLineCount,
    showGridLine = showGridLine,
    currentLines = currentLines,
    currentLineCandidates = currentLineCandidates,
    selectedGridCells = currentSelectedCells,
    eraserRadius = eraserRadius,
    modifier = modifier,
    eraserColor = eraserColor,
    lineColor = lineColor,
    candidateLineColor = candidateLineColor,
    eraserCenter = eraserCenter,
    interactionType = interactionType,
    transformationScale = transformationScale,
    transformationRotation = transformationRotation,
    translationAmount = translationAmount,
    onChangeEraserCenter = onChangeEraserCenter,
    onChangeTransformationScale = onChangeTransformationScale,
    onChangeTransformationRotation = onChangeTransformationRotation,
    onChangeTransformationOffset = onChangeTransformationOffset,
    onResetTransformations = onResetTransformations,
    onDrawScope = onDrawScope
)