package com.cerve.development.ui.canvas.operators

import com.cerve.development.ui.canvas.model.CerveCell
import com.cerve.development.ui.canvas.model.CerveOffset
import com.cerve.development.ui.canvas.model.CerveSize

fun CerveOffset.cell(spacing: Float) : CerveCell {

    val topLeft = CerveOffset(
        x = x * spacing,
        y = y * spacing
    )

    val size = CerveSize(
        width = spacing,
        height = spacing
    )

    return CerveCell(
        topLeft = topLeft,
        cellSize = size
    )
}