package com.cerve.development.ui.canvas.model

import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.setValue
import androidx.compose.runtime.toMutableStateList
import com.cerve.development.ui.canvas.operators.CerveCanvasDefaults
import kotlinx.serialization.Serializable

@Serializable
data class CerveCanvasState(
    private val initialLines: CerveCanvasLineData = CerveCanvasDefaults.canvasLines,
    private val initialEraserProperties: CerveCanvasEraserProperties = CerveCanvasDefaults.canvasEraserProperties,
    private val initialTransformations: CerveCanvasTransformations = CerveCanvasDefaults.canvasTransformations,
    private val initialInteractionType: CerveCanvasInteractionType = CerveCanvasInteractionType.None
) {

    var eraserProperties by mutableStateOf(initialEraserProperties)
        private set

    var gridLineCount by mutableStateOf(initialLines.gridLineCount)
        private set

    var transformations by mutableStateOf(initialTransformations)
        private set

    var interactionType by mutableStateOf(initialInteractionType)
        private set

    val drawnLines: MutableList<CerveLine> = initialLines.drawnLines.toMutableStateList()
    val drawnHistoryLines: MutableList<CerveLine> = initialLines.drawnHistoryLines.toMutableStateList()
    val drawnLineCandidates: MutableList<CerveLine> = initialLines.drawnLineCandidates.toMutableStateList()

    val selectedCells: MutableList<CerveCell> = initialLines.selectedCells.toMutableStateList()

    fun onUpdateEraserProperties(
        value: CerveCanvasEraserProperties
    ) { eraserProperties = value }

    fun onUpdateGridLineCount(
        value: Int
    ) { gridLineCount = value }

    fun onUpdateTransformations(
        value: CerveCanvasTransformations?
    ) { transformations = value ?: initialTransformations }

    fun onChangeInteractionType(
        value: CerveCanvasInteractionType
    ) { interactionType = value }

    fun onUndo() {
        val removed = drawnLines.removeLastOrNull()
        removed?.let { drawnHistoryLines.add(removed) }
    }

    fun onRedo() {
        val history = drawnHistoryLines.removeLastOrNull()
        history?.let { drawnLines.add(history) }
    }

    fun onClear() {
        drawnHistoryLines.clear()
        drawnLines.clear()
        drawnLineCandidates.clear()
    }

}
