package com.cerve.development.ui.canvas.model

import androidx.compose.ui.geometry.Offset
import com.cerve.development.ui.canvas.model.CerveOffset.Companion.offset
import kotlinx.serialization.Serializable

@Serializable
data class CerveLine(
    val start: CerveOffset,
    val end: CerveOffset
) {

    fun plus(value: Offset) : CerveLine {
        return CerveLine(
            start = (start.offset + value).offset,
            end = (end.offset + value).offset
        )
    }

    companion object {
        val Zero = CerveLine(
            start = CerveOffset.Zero,
            end = CerveOffset.Zero
        )

        fun defaultCerveLine(
            start: CerveOffset,
            end: CerveOffset
        ) = CerveLine(
            start = start,
            end = end
        )
    }
}
