package com.cerve.development.ui.canvas.operators

import androidx.compose.ui.geometry.Offset
import kotlin.math.pow
import kotlin.math.sqrt

fun checkCircleSegmentIntersection(
    circleCenter: Offset,
    circleRadius: Float,
    segmentStart: Offset,
    segmentEnd: Offset
): Boolean {
    val dx = segmentEnd.x - segmentStart.x
    val dy = segmentEnd.y - segmentStart.y

    // Early exit if segment is a point
    if (dx == 0f && dy == 0f) {
        return checkCirclePointIntersection(circleCenter, circleRadius, segmentStart)
    }

    // Calculate t (parameter along the line segment)
    val t = ((circleCenter.x - segmentStart.x) * dx + (circleCenter.y - segmentStart.y) * dy) / (dx * dx + dy * dy)

    // Clamp t to the range [0, 1] to get the closest point on the segment
    val clampedT = t.coerceIn(0f, 1f)

    // Calculate the closest point
    val closestX = segmentStart.x + clampedT * dx
    val closestY = segmentStart.y + clampedT * dy

    // Calculate the squared distance (avoiding sqrt)
    val sqrDistance = (closestX - circleCenter.x).toDouble().pow(2.0) +
            (closestY - circleCenter.y).toDouble().pow(2.0)

    // Compare squared distance with squared radius
    return sqrDistance <= circleRadius.toDouble().pow(2.0)
}

fun checkCirclePointIntersection(
    circleCenter: Offset,
    circleRadius: Float,
    point: Offset
): Boolean {
    val distance = sqrt(
        (point.x - circleCenter.x).pow(2) + (point.y - circleCenter.y).pow(2)
    )
    return distance <= circleRadius
}
