/*
 * Decompiled with CFR 0.152.
 */
package com.cerve.development.ui.canvas.model;

import androidx.compose.runtime.internal.StabilityInferred;
import com.cerve.development.ui.canvas.model.CerveCanvasGridProperties$;
import com.cerve.development.ui.canvas.model.CerveGridLinePair;
import com.cerve.development.ui.canvas.model.CerveLine;
import com.cerve.development.ui.canvas.model.CerveOffset;
import com.cerve.development.ui.canvas.model.CerveOffset$;
import com.cerve.development.ui.canvas.model.CerveSize;
import com.cerve.development.ui.canvas.model.CerveSize$;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 ,2\u00020\u0001:\u0002+,B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B?\b\u0010\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u0006\u0010\u000eJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005J\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\u0005H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001J%\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0001\u00a2\u0006\u0002\b*R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012\u00a8\u0006-"}, d2={"Lcom/cerve/development/ui/canvas/model/CerveCanvasGridProperties;", "", "size", "Lcom/cerve/development/ui/canvas/model/CerveSize;", "gridLineCount", "", "<init>", "(Lcom/cerve/development/ui/canvas/model/CerveSize;I)V", "seen0", "gridCenter", "Lcom/cerve/development/ui/canvas/model/CerveOffset;", "gridSpacing", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILcom/cerve/development/ui/canvas/model/CerveSize;ILcom/cerve/development/ui/canvas/model/CerveOffset;ILkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getSize", "()Lcom/cerve/development/ui/canvas/model/CerveSize;", "getGridLineCount", "()I", "getGridCenter", "()Lcom/cerve/development/ui/canvas/model/CerveOffset;", "getGridSpacing", "gridLine", "Lcom/cerve/development/ui/canvas/model/CerveGridLinePair;", "step", "translatedGridLine", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$canvas_release", "$serializer", "Companion", "canvas_release"})
@StabilityInferred(parameters=1)
public final class CerveCanvasGridProperties {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CerveSize size;
    private final int gridLineCount;
    @NotNull
    private final CerveOffset gridCenter;
    private final int gridSpacing;
    public static final int $stable;

    public CerveCanvasGridProperties(@NotNull CerveSize size, int gridLineCount) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        this.size = size;
        this.gridLineCount = gridLineCount;
        this.gridCenter = this.size.getCenter();
        this.gridSpacing = MathKt.roundToInt((float)this.size.spacing(this.gridLineCount));
    }

    @NotNull
    public final CerveSize getSize() {
        return this.size;
    }

    public final int getGridLineCount() {
        return this.gridLineCount;
    }

    @NotNull
    public final CerveOffset getGridCenter() {
        return this.gridCenter;
    }

    public final int getGridSpacing() {
        return this.gridSpacing;
    }

    @NotNull
    public final CerveGridLinePair gridLine(int step) {
        float stepOffset = step * this.gridSpacing;
        CerveOffset xStart = new CerveOffset(stepOffset, 0.0f);
        CerveOffset xEnd = new CerveOffset(stepOffset, this.size.getSpan());
        CerveLine xLine = new CerveLine(xStart, xEnd);
        CerveOffset yStart = new CerveOffset(0.0f, stepOffset);
        CerveOffset yEnd = new CerveOffset(this.size.getSpan(), stepOffset);
        CerveLine yLine = new CerveLine(yStart, yEnd);
        return new CerveGridLinePair(xLine, yLine);
    }

    @NotNull
    public final CerveGridLinePair translatedGridLine(int step) {
        int stepOffset = step * this.gridSpacing;
        float xStepOffset = (float)stepOffset + this.size.getCenter().getX();
        float yStepOffset = (float)stepOffset + this.size.getCenter().getY();
        CerveOffset xStart = new CerveOffset(xStepOffset, this.size.getCenter().getY());
        CerveOffset xEnd = new CerveOffset(xStepOffset, this.size.getCenter().getY() + this.size.getSpan());
        CerveLine xLine = new CerveLine(xStart, xEnd);
        CerveOffset yStart = new CerveOffset(this.size.getCenter().getX(), yStepOffset);
        CerveOffset yEnd = new CerveOffset(this.size.getCenter().getX() + this.size.getSpan(), yStepOffset);
        CerveLine yLine = new CerveLine(yStart, yEnd);
        return new CerveGridLinePair(xLine, yLine);
    }

    @NotNull
    public final CerveSize component1() {
        return this.size;
    }

    public final int component2() {
        return this.gridLineCount;
    }

    @NotNull
    public final CerveCanvasGridProperties copy(@NotNull CerveSize size, int gridLineCount) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        return new CerveCanvasGridProperties(size, gridLineCount);
    }

    public static /* synthetic */ CerveCanvasGridProperties copy$default(CerveCanvasGridProperties cerveCanvasGridProperties, CerveSize cerveSize, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            cerveSize = cerveCanvasGridProperties.size;
        }
        if ((n2 & 2) != 0) {
            n = cerveCanvasGridProperties.gridLineCount;
        }
        return cerveCanvasGridProperties.copy(cerveSize, n);
    }

    @NotNull
    public String toString() {
        return "CerveCanvasGridProperties(size=" + this.size + ", gridLineCount=" + this.gridLineCount + ")";
    }

    public int hashCode() {
        int result = this.size.hashCode();
        result = result * 31 + Integer.hashCode(this.gridLineCount);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CerveCanvasGridProperties)) {
            return false;
        }
        CerveCanvasGridProperties cerveCanvasGridProperties = (CerveCanvasGridProperties)other;
        if (!Intrinsics.areEqual((Object)this.size, (Object)cerveCanvasGridProperties.size)) {
            return false;
        }
        return this.gridLineCount == cerveCanvasGridProperties.gridLineCount;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$canvas_release(CerveCanvasGridProperties self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)CerveSize$.serializer.INSTANCE, (Object)self.size);
        output.encodeIntElement(serialDesc, 1, self.gridLineCount);
        if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : !Intrinsics.areEqual((Object)self.gridCenter, (Object)self.size.getCenter())) {
            output.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)CerveOffset$.serializer.INSTANCE, (Object)self.gridCenter);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : self.gridSpacing != MathKt.roundToInt((float)self.size.spacing(self.gridLineCount))) {
            output.encodeIntElement(serialDesc, 3, self.gridSpacing);
        }
    }

    public /* synthetic */ CerveCanvasGridProperties(int seen0, CerveSize size, int gridLineCount, CerveOffset gridCenter, int gridSpacing, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.size = size;
        this.gridLineCount = gridLineCount;
        this.gridCenter = (seen0 & 4) == 0 ? this.size.getCenter() : gridCenter;
        this.gridSpacing = (seen0 & 8) == 0 ? MathKt.roundToInt((float)this.size.spacing(this.gridLineCount)) : gridSpacing;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/cerve/development/ui/canvas/model/CerveCanvasGridProperties$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/cerve/development/ui/canvas/model/CerveCanvasGridProperties;", "canvas_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<CerveCanvasGridProperties> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

