package com.cerve.development.ui.canvas.component

import androidx.compose.foundation.layout.BoxWithConstraints
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.drawscope.DrawScope
import com.cerve.development.ui.canvas.model.CerveCanvasColors
import com.cerve.development.ui.canvas.model.CerveCanvasEraserProperties
import com.cerve.development.ui.canvas.model.CerveCanvasGridConfigurations
import com.cerve.development.ui.canvas.model.CerveCanvasGridProperties
import com.cerve.development.ui.canvas.model.CerveCanvasInteractionType
import com.cerve.development.ui.canvas.model.CerveCanvasProperties
import com.cerve.development.ui.canvas.model.CerveCanvasState
import com.cerve.development.ui.canvas.model.CerveCanvasTransformations
import com.cerve.development.ui.canvas.model.CerveCell
import com.cerve.development.ui.canvas.model.CerveLine
import com.cerve.development.ui.canvas.operators.CerveCanvasDefaults
import com.cerve.development.ui.canvas.operators.CerveCanvasDefaults.canvasGridConfigurations
import com.cerve.development.ui.canvas.operators.rememberCanvasGridProperties
import com.cerve.development.ui.canvas.operators.rememberCerveDrawCanvasState

@Composable
fun CerveCanvas(
    modifier: Modifier = Modifier,
    canvasState: CerveCanvasState = rememberCerveDrawCanvasState(),
    colors: CerveCanvasColors = CerveCanvasDefaults.canvasColors,
    canvasProperties: CerveCanvasProperties = CerveCanvasDefaults.canvasProperties,
    canvasGridConfigurations: CerveCanvasGridConfigurations = canvasGridConfigurations(colors),
    drawnLines: MutableList<CerveLine> = canvasState.drawnLines,
    drawnLineCandidates: MutableList<CerveLine> = canvasState.drawnLineCandidates,
    selectedGridCells: MutableList<CerveCell> = canvasState.selectedCells,
    selectedCellCandidate: CerveCell? = canvasState.selectedCellCandidate,
    interactionType: CerveCanvasInteractionType? = canvasState.interactionType,
    transformations: () -> CerveCanvasTransformations = { canvasState.transformations },
    eraserProperties: () -> CerveCanvasEraserProperties = { canvasState.eraserProperties },
    onUpdateTransformations: (CerveCanvasTransformations?) -> Unit = canvasState::onUpdateTransformations,
    onUpdateEraserProperties: (CerveCanvasEraserProperties) -> Unit = canvasState::onUpdateEraserProperties,
    onUpdateSelectedCellCandidate: (CerveCell?) -> Unit = canvasState::onUpdateSelectedCellCandidate,
) = CerveCanvasWithDrawScope(
    modifier = modifier,
    canvasState = canvasState,
    colors = colors,
    canvasProperties = canvasProperties,
    canvasGridConfigurations = canvasGridConfigurations,
    drawnLines = drawnLines,
    drawnLineCandidates = drawnLineCandidates,
    selectedGridCells = selectedGridCells,
    selectedCellCandidate = selectedCellCandidate,
    interactionType = interactionType,
    transformations = transformations,
    eraserProperties = eraserProperties,
    onUpdateTransformations = onUpdateTransformations,
    onUpdateEraserProperties = onUpdateEraserProperties,
    onUpdateSelectedCellCandidate = onUpdateSelectedCellCandidate,
    onDrawScope = { }
)

@Composable
fun CerveCanvasWithDrawScope(
    modifier: Modifier = Modifier,
    canvasState: CerveCanvasState = rememberCerveDrawCanvasState(),
    colors: CerveCanvasColors = CerveCanvasDefaults.canvasColors,
    canvasProperties: CerveCanvasProperties = CerveCanvasDefaults.canvasProperties,
    canvasGridConfigurations: CerveCanvasGridConfigurations = canvasGridConfigurations(colors),
    drawnLines: MutableList<CerveLine> = canvasState.drawnLines,
    drawnLineCandidates: MutableList<CerveLine> = canvasState.drawnLineCandidates,
    selectedGridCells: MutableList<CerveCell> = canvasState.selectedCells,
    selectedCellCandidate: CerveCell? = canvasState.selectedCellCandidate,
    interactionType: CerveCanvasInteractionType? = canvasState.interactionType,
    transformations: () -> CerveCanvasTransformations = { canvasState.transformations },
    eraserProperties: () -> CerveCanvasEraserProperties = { canvasState.eraserProperties },
    onUpdateTransformations: (CerveCanvasTransformations?) -> Unit = canvasState::onUpdateTransformations,
    onUpdateEraserProperties: (CerveCanvasEraserProperties) -> Unit = canvasState::onUpdateEraserProperties,
    onUpdateSelectedCellCandidate: (CerveCell?) -> Unit = canvasState::onUpdateSelectedCellCandidate,
    onDrawScope: DrawScope.() -> Unit
) {

    BoxWithConstraints(modifier = modifier) {

        val canvasGridProperties = rememberCanvasGridProperties(canvasState.gridLineCount)

        CerveCanvasWithDrawScope(
            modifier = modifier,
            canvasState = canvasState,
            colors = colors,
            canvasProperties = canvasProperties,
            canvasGridProperties = canvasGridProperties,
            canvasGridConfigurations = canvasGridConfigurations,
            drawnLines = drawnLines,
            drawnLineCandidates = drawnLineCandidates,
            selectedGridCells = selectedGridCells,
            selectedCellCandidate = selectedCellCandidate,
            interactionType = interactionType,
            transformations = transformations,
            eraserProperties = eraserProperties,
            onUpdateTransformations = onUpdateTransformations,
            onUpdateEraserProperties = onUpdateEraserProperties,
            onUpdateSelectedCellCandidate = onUpdateSelectedCellCandidate,
            onDrawScope = onDrawScope
        )
    }

}
