package com.cerve.development.ui.canvas.model

import kotlinx.serialization.Serializable
import kotlin.math.roundToInt

@Serializable
data class CerveCanvasGridProperties(
    val size: CerveSize,
    val lineCount: Int,
    val spacing: Int = size.spacing(lineCount).roundToInt(),
    val center: CerveOffset = size.center,
    val start: Int = 0,
    val end: Int = spacing * lineCount,
    val dimensions: CerveDimensions = CerveDimensions(spacing, start..end)
) {

    fun gridLine(step: Int) : CerveGridLinePair {
        val stepOffset = (step * spacing).toFloat()

        val xStart = CerveOffset(x = stepOffset, y = 0f)
        val xEnd = CerveOffset(x = stepOffset, y = size.span)

        val xLine = CerveLine(start = xStart, end = xEnd)

        val yStart = CerveOffset(x = 0f, y = stepOffset)
        val yEnd = CerveOffset(x = size.span, y = stepOffset)

        val yLine = CerveLine(start = yStart, end = yEnd)

        return CerveGridLinePair(xLine = xLine, yLine = yLine)
    }
}
