package com.cerve.development.ui.canvas.operators

import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.drawWithCache
import androidx.compose.ui.graphics.drawscope.translate
import androidx.compose.ui.graphics.graphicsLayer
import com.cerve.development.ui.canvas.model.CerveCanvasGridConfigurations
import com.cerve.development.ui.canvas.model.CerveCanvasGridProperties
import com.cerve.development.ui.canvas.model.CerveCanvasTransformations

fun Modifier.drawGrid(
    configurations: CerveCanvasGridConfigurations,
    properties: CerveCanvasGridProperties,
    shouldShowGridLine: Boolean,
) : Modifier = if (shouldShowGridLine) {
    drawWithCache {
        onDrawBehind {
            translate(
                left = properties.center.x,
                top = properties.center.y
            ) {
                (0..properties.lineCount).forEach { x ->

                    val isStepOf = try {
                        x  % configurations.step == 0
                    } catch (_: Exception) {
                        false
                    }

                    val gridLinePair = properties.gridLine(x)

                    drawLine(
                        start = gridLinePair.xLine.start.offset,
                        end = gridLinePair.xLine.end.offset,
                        color = configurations.gridColor(isStepOf),
                        strokeWidth = configurations.gridStrokeWidth(isStepOf)
                    )
                    drawLine(
                        start = gridLinePair.yLine.start.offset,
                        end = gridLinePair.yLine.end.offset,
                        color = configurations.gridColor(isStepOf),
                        strokeWidth = configurations.gridStrokeWidth(isStepOf)
                    )

                }
            }
        }

    }
} else this

fun Modifier.graphicLayerTransformation(
    transformations: () -> CerveCanvasTransformations
) : Modifier = graphicsLayer {
    scaleX = transformations().scale
    scaleY = transformations().scale
    rotationZ = transformations().rotation
    translationX = transformations().offset.x.toFloat()
    translationY = transformations().offset.y.toFloat()
}

