package com.cerve.development.ui.canvas.operators

import androidx.compose.material3.MaterialTheme.colorScheme
import androidx.compose.runtime.Composable
import com.cerve.development.ui.canvas.model.CerveCanvasColors
import com.cerve.development.ui.canvas.model.CerveCanvasEraserProperties
import com.cerve.development.ui.canvas.model.CerveCanvasGridConfigurations
import com.cerve.development.ui.canvas.model.CerveCanvasLineData
import com.cerve.development.ui.canvas.model.CerveCanvasProperties
import com.cerve.development.ui.canvas.model.CerveCanvasTransformations
import com.cerve.development.ui.canvas.model.CerveOffset
import com.cerve.development.ui.canvas.model.CerveTransformOrigin

object CerveCanvasDefaults {

    const val GRID_LINE_STROKE = 0.5f
    const val GRID_LINE_COUNT = 10
    const val STROKE_WIDTH = 12f
    const val ERASER_RADIUS = 10f

    const val BASE_SCALE = 1f
    const val BASE_ROTATION = 0f

    @get:Composable
    val canvasColors: CerveCanvasColors get() = CerveCanvasColors(
        eraserColor = colorScheme.secondary,
        drawColor = colorScheme.primary,
        drawCandidateColor = colorScheme.secondary,
        gridCellColor = colorScheme.tertiary,
        gridLineColor = colorScheme.onSurface,
        gridLineStepColor = colorScheme.onSurfaceVariant
    )

    val canvasTransformations get() = CerveCanvasTransformations(
        offset = CerveOffset.Zero,
        scale = BASE_SCALE,
        rotation = BASE_ROTATION,
        origin = CerveTransformOrigin.Zero
    )

    val canvasEraserProperties get() = CerveCanvasEraserProperties(
        radius = ERASER_RADIUS,
        center = null
    )

    val canvasProperties get() = CerveCanvasProperties(
        strokeWidth = STROKE_WIDTH,
        shouldShowGridLine = true
    )

    val canvasLines get() = CerveCanvasLineData(
        drawnLines = emptyList(),
        drawnLineCandidates = emptyList(),
        drawnHistoryLines = emptyList(),
        selectedCells = emptyList(),
        gridLineCount = GRID_LINE_COUNT
    )

    @Composable
    fun canvasGridConfigurations(colors: CerveCanvasColors) = CerveCanvasGridConfigurations(
        color = colors.gridLineColor,
        strokeWidth = GRID_LINE_STROKE,
        step = 0,
        stepColor = colors.gridLineStepColor
    )
}