package com.cerve.development.ui.canvas.operators.guestures

import androidx.compose.foundation.gestures.detectTapGestures
import androidx.compose.ui.input.pointer.PointerInputScope
import com.cerve.development.ui.canvas.model.CerveCell
import com.cerve.development.ui.canvas.model.CerveDimensions
import com.cerve.development.ui.canvas.model.CerveLine
import com.cerve.development.ui.canvas.model.CerveOffset
import com.cerve.development.ui.canvas.model.CerveSize
import com.cerve.development.ui.canvas.operators.snapToFloor


suspend fun PointerInputScope.multiSelectorGestures(
    translationAmount: CerveOffset,
    drawnLines: MutableList<CerveLine>,
    selectedGridCells: MutableList<CerveCell>,
    selectableDimensions: CerveDimensions
) = detectTapGestures { tapPosition ->

    val offset = tapPosition - translationAmount.offset
    val position = offset.snapToFloor(selectableDimensions.spacing)

    val exists = selectedGridCells.firstOrNull { cell ->
        cell.offset == position.offset
    }

    when {
        exists != null -> { selectedGridCells.remove(exists) }
        selectableDimensions.inBounds(offset, drawnLines) -> {
            val cell = CerveCell(
                topLeft = position,
                cellSize = CerveSize(
                    width = selectableDimensions.spacing,
                    height = selectableDimensions.spacing
                )
            )

            selectedGridCells.add(cell)
        }
    }

}

suspend fun PointerInputScope.singleSelectorGestures(
    translationAmount: CerveOffset,
    drawnLines: MutableList<CerveLine>,
    selectedGridCells: MutableList<CerveCell>,
    selectableDimensions: CerveDimensions
) = detectTapGestures { tapPosition ->

    val offset = tapPosition - translationAmount.offset
    val position = offset.snapToFloor(selectableDimensions.spacing)

    val exists = selectedGridCells.firstOrNull { cell ->
        cell.offset == position.offset
    }

    when {
        exists != null -> { selectedGridCells.remove(exists) }
        selectableDimensions.inBounds(offset, drawnLines) -> {
            selectedGridCells.clear()
            val cell = CerveCell(
                topLeft = position,
                cellSize = CerveSize(size = selectableDimensions.spacing)
            )

            selectedGridCells.add(cell)
        }
    }

}