package com.cerve.development.ui.canvas.component

import androidx.compose.foundation.Canvas
import androidx.compose.foundation.layout.BoxWithConstraintsScope
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.drawscope.DrawScope
import com.cerve.development.ui.canvas.model.CerveCanvasColors
import com.cerve.development.ui.canvas.model.CerveCanvasEraserProperties
import com.cerve.development.ui.canvas.model.CerveCanvasGridConfigurations
import com.cerve.development.ui.canvas.model.CerveCanvasGridProperties
import com.cerve.development.ui.canvas.model.CerveCanvasInteractionType
import com.cerve.development.ui.canvas.model.CerveCanvasProperties
import com.cerve.development.ui.canvas.model.CerveCanvasState
import com.cerve.development.ui.canvas.model.CerveCanvasTransformations
import com.cerve.development.ui.canvas.model.CerveCell
import com.cerve.development.ui.canvas.model.CerveLine
import com.cerve.development.ui.canvas.operators.CerveCanvasDefaults
import com.cerve.development.ui.canvas.operators.canvasScope
import com.cerve.development.ui.canvas.operators.draw.canvasInput
import com.cerve.development.ui.canvas.operators.draw.gridCellSelectorInput
import com.cerve.development.ui.canvas.operators.drawGrid
import com.cerve.development.ui.canvas.operators.graphicLayerTransformation
import com.cerve.development.ui.canvas.operators.rememberCanvasGridProperties
import com.cerve.development.ui.canvas.operators.rememberCerveDrawCanvasState
import com.cerve.development.ui.canvas.operators.transformation.zoomInput

@Composable
fun BoxWithConstraintsScope.CerveCanvas(
    modifier: Modifier = Modifier,
    canvasState: CerveCanvasState = rememberCerveDrawCanvasState(),
    colors: CerveCanvasColors = CerveCanvasDefaults.canvasColors,
    canvasProperties: CerveCanvasProperties = CerveCanvasDefaults.canvasProperties,
    canvasGridConfigurations: CerveCanvasGridConfigurations = CerveCanvasDefaults.canvasGridConfigurations(colors),
    canvasGridProperties: CerveCanvasGridProperties = rememberCanvasGridProperties(canvasState.gridLineCount),
    drawnLines: MutableList<CerveLine> = canvasState.drawnLines,
    drawnLineCandidates: MutableList<CerveLine> = canvasState.drawnLineCandidates,
    selectedGridCellList: MutableList<CerveCell> = canvasState.selectedCellList,
    selectedGridCell: CerveCell? = canvasState.selectedCell,
    selectedCellCandidate: CerveCell? = canvasState.selectedCellCandidate,
    interactionType: CerveCanvasInteractionType? = canvasState.interactionType,
    transformations: () -> CerveCanvasTransformations = { canvasState.transformations },
    eraserProperties: () -> CerveCanvasEraserProperties = { canvasState.eraserProperties },
    onUpdateTransformations: (CerveCanvasTransformations?) -> Unit = canvasState::onUpdateTransformations,
    onUpdateEraserProperties: (CerveCanvasEraserProperties) -> Unit = canvasState::onUpdateEraserProperties,
    onUpdateSelectedCell: (CerveCell?) -> Unit = canvasState::onUpdateSelectedCell,
    onUpdateSelectedCellCandidate: (CerveCell?) -> Unit = canvasState::onUpdateSelectedCellCandidate
) = CerveCanvasWithDrawScope(
    modifier = modifier,
    canvasState = canvasState,
    colors = colors,
    canvasProperties = canvasProperties,
    canvasGridProperties = canvasGridProperties,
    canvasGridConfigurations = canvasGridConfigurations,
    drawnLines = drawnLines,
    drawnLineCandidates = drawnLineCandidates,
    selectedGridCellList = selectedGridCellList,
    selectedGridCell = selectedGridCell,
    selectedCellCandidate = selectedCellCandidate,
    interactionType = interactionType,
    transformations = transformations,
    eraserProperties = eraserProperties,
    onUpdateTransformations = onUpdateTransformations,
    onUpdateEraserProperties = onUpdateEraserProperties,
    onUpdateSelectedCell = onUpdateSelectedCell,
    onUpdateSelectedCellCandidate = onUpdateSelectedCellCandidate,
    onDrawScope = { }
)

@Composable
fun BoxWithConstraintsScope.CerveCanvasWithDrawScope(
    modifier: Modifier = Modifier,
    canvasState: CerveCanvasState = rememberCerveDrawCanvasState(),
    colors: CerveCanvasColors = CerveCanvasDefaults.canvasColors,
    canvasProperties: CerveCanvasProperties = CerveCanvasDefaults.canvasProperties,
    canvasGridConfigurations: CerveCanvasGridConfigurations = CerveCanvasDefaults.canvasGridConfigurations(colors),
    canvasGridProperties: CerveCanvasGridProperties = rememberCanvasGridProperties(canvasState.gridLineCount),
    drawnLines: MutableList<CerveLine> = canvasState.drawnLines,
    drawnLineCandidates: MutableList<CerveLine> = canvasState.drawnLineCandidates,
    selectedGridCellList: MutableList<CerveCell> = canvasState.selectedCellList,
    selectedGridCell: CerveCell? = canvasState.selectedCell,
    selectedCellCandidate: CerveCell? = canvasState.selectedCellCandidate,
    interactionType: CerveCanvasInteractionType? = canvasState.interactionType,
    transformations: () -> CerveCanvasTransformations = { canvasState.transformations },
    eraserProperties: () -> CerveCanvasEraserProperties = { canvasState.eraserProperties },
    onUpdateTransformations: (CerveCanvasTransformations?) -> Unit = canvasState::onUpdateTransformations,
    onUpdateEraserProperties: (CerveCanvasEraserProperties) -> Unit = canvasState::onUpdateEraserProperties,
    onUpdateSelectedCell: (CerveCell?) -> Unit = canvasState::onUpdateSelectedCell,
    onUpdateSelectedCellCandidate: (CerveCell?) -> Unit = canvasState::onUpdateSelectedCellCandidate,
    onDrawScope: DrawScope.() -> Unit
) {
    Canvas(
        modifier = modifier
            .matchParentSize()
            .graphicLayerTransformation(transformations)
            .zoomInput(
                interactionType = interactionType,
                transformations = transformations,
                onUpdateTransformations = onUpdateTransformations
            ).canvasInput(
                interactionType = interactionType,
                drawnLines = drawnLines,
                drawnLineCandidates = drawnLineCandidates,
                selectedGridCell = selectedGridCell,
                selectedGridCellList = selectedGridCellList,
                gridProperties = canvasGridProperties,
                eraserProperties = eraserProperties,
                onUpdateEraserProperties = onUpdateEraserProperties,
                onUpdateSelectedGridCell = onUpdateSelectedCell
            ).drawGrid(
                configurations = canvasGridConfigurations,
                properties = canvasGridProperties,
                shouldShowGridLine = canvasProperties.shouldShowGridLine
            ).gridCellSelectorInput(
                interactionType = interactionType,
                gridCenter = canvasGridProperties.center,
                gridSpacing = canvasGridProperties.spacing,
                onUpdateSelectedCellCandidate = onUpdateSelectedCellCandidate
            )
    ) {
        canvasScope(
            strokeWidth = canvasProperties.strokeWidth,
            eraserColor = colors.eraserColor,
            drawColor = colors.drawColor,
            drawCandidateColor = colors.drawCandidateColor,
            gridCellColor = colors.gridCellColor,
            gridCellAltColor = colors.gridCellAltColor,
            eraserProperties = eraserProperties,
            drawnLines = drawnLines,
            drawnLineCandidates = drawnLineCandidates,
            selectedGridCellList = selectedGridCellList,
            selectedGridCell = selectedGridCell,
            selectedCellCandidate = selectedCellCandidate,
            gridCenter = canvasGridProperties.center,
            scope = onDrawScope
        )
    }
}