package com.cerve.development.ui.canvas.model

import androidx.compose.ui.graphics.Color

data class CerveCanvasGridConfigurations(
    val color: Color,
    private val strokeWidth: Float,
    val step: Int,
    val stepColor: Color,
) {
    fun gridStrokeWidth(isStep: Boolean) = if (isStep) (strokeWidth * 10) else strokeWidth
    fun gridColor(isStep: Boolean) = if (isStep) stepColor else color
}