package com.cerve.development.ui.canvas.operators

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.drawscope.DrawScope
import androidx.compose.ui.graphics.drawscope.Fill
import androidx.compose.ui.graphics.drawscope.translate
import com.cerve.development.ui.canvas.model.CerveCanvasEraserProperties
import com.cerve.development.ui.canvas.model.CerveCell
import com.cerve.development.ui.canvas.model.CerveLine
import com.cerve.development.ui.canvas.model.CerveOffset

fun DrawScope.canvasScope(
    strokeWidth: Float,
    eraserColor: Color,
    eraserProperties: () -> CerveCanvasEraserProperties,
    drawColor: Color,
    gridCellColor: Color,
    gridCellAltColor: Color,
    drawnLines: MutableList<CerveLine>,
    drawCandidateColor: Color,
    drawnLineCandidates: MutableList<CerveLine>,
    selectedGridCellList: MutableList<CerveCell>,
    selectedGridCell: CerveCell?,
    selectedCellCandidate: CerveCell?,
    gridCenter: CerveOffset,
    scope: DrawScope.() -> Unit = { }
) {

    translate(left = gridCenter.x, top = gridCenter.y) {

        selectedGridCellList.forEach { cell ->
            drawRect(
                color = gridCellColor,
                topLeft = cell.offset,
                size = cell.size
            )
        }

        selectedGridCell?.let { cell ->
            drawRect(
                color = gridCellColor,
                topLeft = cell.offset,
                size = cell.size
            )
        }

        selectedCellCandidate?.let { cell ->
            drawRect(
                color = gridCellAltColor,
                topLeft = cell.offset,
                size = cell.size
            )
        }

        drawnLineCandidates.forEach { line ->
            drawLine(
                color = drawCandidateColor,
                start = line.start.offset,
                end = line.end.offset,
                strokeWidth = strokeWidth,
                cap = StrokeCap.Round
            )
        }

        drawnLines.forEach { line ->
            drawLine(
                color = drawColor,
                start = line.start.offset,
                end = line.end.offset,
                strokeWidth = strokeWidth,
                cap = StrokeCap.Round
            )
        }

        eraserProperties().center?.let { center ->
            drawCircle(
                color = eraserColor,
                center = center.offset,
                radius = eraserProperties().radius,
                style = Fill
            )
        }

        scope()
    }
}