package com.cerve.development.ui.canvas.operators

import androidx.compose.ui.geometry.Offset
import com.cerve.development.ui.canvas.model.CerveLine
import com.cerve.development.ui.canvas.model.CerveOffset
import kotlin.math.ceil
import kotlin.math.floor
import kotlin.math.round

fun Float.roundToFloor(base: Int) : Float {
   return base * floor(this / base)
}

fun Offset.snapToFloor(spacing: Int): CerveOffset {
    val snappedX = x.roundToFloor(spacing)
    val snappedY = y.roundToFloor(spacing)
    return CerveOffset(snappedX, snappedY)
}
fun CerveOffset.snapToFloor(spacing: Int): CerveOffset {
    val snappedX = x.roundToFloor(spacing)
    val snappedY = y.roundToFloor(spacing)
    return this.copy(snappedX, snappedY)
}
fun CerveLine.snapToFloor(spacing: Int): CerveLine {
    return CerveLine(
        start = start.snapToFloor(spacing),
        end = end.snapToFloor(spacing)
    )
}

fun Float.roundToCeil(base: Int) : Float {
    return base * ceil(this / base)
}

fun Offset.snapToCeil(spacing: Int): CerveOffset {
    val snappedX = x.roundToCeil(spacing)
    val snappedY = y.roundToCeil(spacing)
    return CerveOffset(snappedX, snappedY)
}
fun CerveOffset.snapToCeil(spacing: Int): CerveOffset {
    val snappedX = x.roundToCeil(spacing)
    val snappedY = y.roundToCeil(spacing)
    return this.copy(snappedX, snappedY)
}
fun CerveLine.snapToCeil(spacing: Int): CerveLine {
    return CerveLine(
        start = start.snapToCeil(spacing),
        end = end.snapToCeil(spacing)
    )
}

fun Float.roundToNear(base: Int) : Float {
    return base * round(this / base)
}

fun Offset.snapToNear(spacing: Int): CerveOffset {
    val snappedX = x.roundToNear(spacing)
    val snappedY = y.roundToNear(spacing)
    return CerveOffset(snappedX, snappedY)
}
fun CerveOffset.snapToNear(spacing: Int): CerveOffset {
    val snappedX = x.roundToNear(spacing)
    val snappedY = y.roundToNear(spacing)
    return this.copy(snappedX, snappedY)
}
fun CerveLine.snapToNear(spacing: Int): CerveLine {
    return CerveLine(
        start = start.snapToNear(spacing),
        end = end.snapToNear(spacing)
    )
}