package com.cerve.development.ui.canvas.model

import androidx.compose.ui.geometry.Offset
import kotlinx.serialization.Serializable

@Serializable
data class CerveOffset(
    val x: Float,
    val y: Float
) {
    val offset get() = run { Offset(x = x.toFloat(), y = y.toFloat()) }
    val transformOrigin = run { CerveTransformOrigin(pivotX = x, pivotY = y) }

    fun div(other: Int) : CerveOffset = copy(x = x/other, y = y/other)

    companion object {
        val Zero = CerveOffset(0f, 0f)
        val Offset.offset get() = run { CerveOffset(x = x, y = y) }

    }
}
