package com.cerve.development.ui.canvas.operators

import com.cerve.development.ui.canvas.model.CerveCanvasGridProperties
import com.cerve.development.ui.canvas.model.CerveLine
import com.cerve.development.ui.canvas.model.CerveOffset

fun CerveCanvasGridProperties.generateSimpleTemplate(
    width: Int,
    length: Int,
    canvasCenter: CerveOffset = CerveOffset.Zero
) : List<CerveLine> {

    val center = canvasCenter.offset
        .minus(size.center.offset)
        .div(2f)

    return mutableListOf<CerveLine>().apply {
        val verticalLineCount = width + 1
        val horizontalLineCount = length + 1

        (0 until verticalLineCount).forEach { verticalCount ->
            val x = center.x + (verticalCount * gridSpacing).toFloat()
            (0 until horizontalLineCount - 1).forEach { horizontalCount ->

                val yS = center.y + (horizontalCount * gridSpacing).toFloat()
                val yE = center.y + ((horizontalCount + 1) * gridSpacing).toFloat()

                val startOffset = CerveOffset(x = x, y = yS)
                    .snapToNear(gridSpacing)

                val endOffset = CerveOffset(x = x, y = yE)
                    .snapToNear(gridSpacing)

                val line = CerveLine(start = startOffset, end = endOffset)

                add(line)
            }
        }

        (0 until horizontalLineCount).forEach { horizontalCount ->
            val y =  center.y + (horizontalCount * gridSpacing).toFloat()
            (0 until verticalLineCount - 1).forEach { verticalCount ->

                val xS = (center.x + (verticalCount + 1) * gridSpacing).toFloat()
                val xE = (center.x + verticalCount * gridSpacing).toFloat()

                val startOffset = CerveOffset(x = xS, y = y)
                    .snapToNear(gridSpacing)

                val endOffset = CerveOffset(x = xE, y = y)
                    .snapToNear(gridSpacing)

                val line = CerveLine(start = startOffset, end = endOffset)

                add(line)
            }
        }

    }
}