package com.cerve.development.ui.canvas.operators

import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.drawWithCache
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.drawscope.translate
import androidx.compose.ui.graphics.graphicsLayer
import com.cerve.development.ui.canvas.model.CerveCanvasGridProperties
import com.cerve.development.ui.canvas.model.CerveOffset

fun Modifier.drawGrid(
    color: Color,
    properties: CerveCanvasGridProperties,
    showGridLine: Boolean
) : Modifier = if (showGridLine) {
    drawWithCache {
        onDrawBehind {
            translate(
                left = properties.translationAmount.x,
                top = properties.translationAmount.y
            ) {
                (0..properties.gridLineCount).forEach { x ->

                    val gridLinePair = properties.gridLine(x)

                    drawLine(
                        start = gridLinePair.xLine.start.offset,
                        end = gridLinePair.xLine.end.offset,
                        color = color
                    )
                    drawLine(
                        start = gridLinePair.yLine.start.offset,
                        end = gridLinePair.yLine.end.offset,
                        color = color
                    )

                }
            }
        }

    }
} else this

fun Modifier.changeOrientation(
    scale: () -> Float,
    rotation: () -> Float,
    offset: () -> CerveOffset
) : Modifier = graphicsLayer {
    scaleX = scale()
    scaleY = scale()
    rotationZ = rotation()
    val offset = offset()
    translationX = offset.x.toFloat()
    translationY = offset.y.toFloat()
}

