package com.cerve.development.ui.canvas.model

import androidx.compose.ui.graphics.TransformOrigin
import kotlinx.serialization.Serializable

@Serializable
data class CerveTransformOrigin(
    private val pivotX: Float,
    private val pivotY: Float
) {

    companion object {
        val CerveTransformOrigin.toTransformOrigin
            get() = TransformOrigin(
                pivotFractionX = pivotX,
                pivotFractionY = pivotY
            )

        val TransformOrigin.toCerveTransformOrigin
            get() = CerveTransformOrigin(
                pivotX = pivotFractionX,
                pivotY = pivotFractionY
            )

        val Center get() = CerveTransformOrigin(
            pivotX = TransformOrigin.Center.pivotFractionX,
            pivotY = TransformOrigin.Center.pivotFractionY
        )

        val Zero get() = CerveTransformOrigin(pivotX = 0f, pivotY = 0f)
    }
}
