package com.cerve.development.ui.canvas.operators

import androidx.compose.material3.MaterialTheme.colorScheme
import androidx.compose.runtime.Composable
import com.cerve.development.ui.canvas.model.CerveCanvasColors
import com.cerve.development.ui.canvas.model.CerveCanvasEraserProperties
import com.cerve.development.ui.canvas.model.CerveCanvasLineData
import com.cerve.development.ui.canvas.model.CerveCanvasLineData.Companion.BASE_GRID_LINE_COUNT
import com.cerve.development.ui.canvas.model.CerveCanvasProperties
import com.cerve.development.ui.canvas.model.CerveCanvasTransformations
import com.cerve.development.ui.canvas.model.CerveOffset
import com.cerve.development.ui.canvas.model.CerveTransformOrigin

object CerveCanvasDefaults {

    @get:Composable
    val canvasColors: CerveCanvasColors get() = CerveCanvasColors(
        eraserColor = colorScheme.secondary,
        drawColor = colorScheme.primary,
        drawCandidateColor = colorScheme.secondary,
        gridCellColor = colorScheme.tertiary,
        gridLineColor = colorScheme.onSurface
    )

    val canvasTransformations get() = CerveCanvasTransformations(
        offset = CerveOffset.Zero,
        scale = CerveCanvasTransformations.BASE_SCALE,
        rotation = CerveCanvasTransformations.BASE_ROTATION,
        origin = CerveTransformOrigin.Zero
    )

    val canvasEraserProperties get() = CerveCanvasEraserProperties(
        radius = CerveCanvasEraserProperties.BASE_RADIUS,
        center = null
    )

    val canvasProperties get() = CerveCanvasProperties(
        strokeWidth = CerveCanvasProperties.BASE_STROKE_WIDTH,
        shouldShowGridLine = true
    )

    val canvasLines get() = CerveCanvasLineData(
        drawnLines = emptyList(),
        drawnLineCandidates = emptyList(),
        drawnHistoryLines = emptyList(),
        selectedCells = emptyList(),
        gridLineCount = BASE_GRID_LINE_COUNT
    )

}