package com.cerve.development.ui.canvas.operators.draw

import androidx.compose.ui.Modifier
import androidx.compose.ui.input.pointer.pointerInput
import com.cerve.development.ui.canvas.model.CerveCanvasEraserProperties
import com.cerve.development.ui.canvas.model.CerveCanvasInteractionType
import com.cerve.development.ui.canvas.model.CerveCell
import com.cerve.development.ui.canvas.model.CerveLine
import com.cerve.development.ui.canvas.model.CerveOffset
import com.cerve.development.ui.canvas.operators.assistedBrushGestures
import com.cerve.development.ui.canvas.operators.brushGestures
import com.cerve.development.ui.canvas.operators.cellSelectorGestures
import com.cerve.development.ui.canvas.operators.eraserGestures
import com.cerve.development.ui.canvas.operators.segmentedBrushGestures

fun Modifier.canvasInput(
    interactionType: CerveCanvasInteractionType?,
    gridSpacing: Int,
    drawnLines: MutableList<CerveLine>,
    drawnLineCandidates: MutableList<CerveLine>,
    selectedGridCells: MutableList<CerveCell>,
    gridCenter: CerveOffset,
    eraserProperties: () -> CerveCanvasEraserProperties,
    onUpdateEraserProperties: (CerveCanvasEraserProperties) -> Unit,
) = pointerInput(interactionType) {
    when(interactionType) {
        CerveCanvasInteractionType.Brush -> {
            brushGestures(
                translationAmount = gridCenter,
                currentLines = drawnLines
            )
        }
        CerveCanvasInteractionType.AssistedBrush -> {
            assistedBrushGestures(
                gridSpacing = gridSpacing,
                translationAmount = gridCenter,
                currentLines = drawnLines,
                currentLineCandidates = drawnLineCandidates,
            )
        }
        CerveCanvasInteractionType.SegmentedBrush -> {
            segmentedBrushGestures(
                gridSpacing = gridSpacing,
                translationAmount = gridCenter,
                currentLines = drawnLines,
                currentLineCandidates = drawnLineCandidates
            )
        }
        CerveCanvasInteractionType.Eraser -> {
            eraserGestures(
                translationAmount = gridCenter,
                currentLines = drawnLines,
                eraserProperties = eraserProperties,
                onUpdateEraserProperties = onUpdateEraserProperties
            )
        }
        CerveCanvasInteractionType.CellSelector -> {
            cellSelectorGestures(
                gridSpacing = gridSpacing,
                translationAmount = gridCenter,
                selectedGridCells = selectedGridCells
            )
        }
        else -> Unit
    }
}
