package com.cerve.development.ui.canvas.operators

import kotlin.math.absoluteValue
import kotlin.math.log10
import kotlin.math.roundToInt

val Int.count get() = when(this) {
    0 -> 1
    else -> log10(toFloat().absoluteValue).toInt() + 1
}

val Float.count get() = when(this.roundToInt()) {
    0 -> 1
    else -> log10(toFloat().absoluteValue).toInt() + 1
}
