package com.cerve.development.ui.canvas.operators

import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.input.pointer.PointerInputChange
import com.cerve.development.ui.canvas.model.CerveLine
import com.cerve.development.ui.canvas.model.CerveLine.Companion.defaultCerveLine
import com.cerve.development.ui.canvas.model.CerveOffset.Companion.offset

fun MutableList<CerveLine>.consumeLine(
    change: PointerInputChange,
    dragAmount: Offset,
    translationAmount: Offset
) {
    change.consume()
    val start = (change.position - dragAmount - translationAmount)
    val end = (change.position - translationAmount)

    val line = defaultCerveLine(
        start = start.offset,
        end = end.offset
    )

    add(line)
}
