package com.cerve.development.ui.canvas.operators

import androidx.compose.foundation.layout.BoxWithConstraintsScope
import androidx.compose.runtime.Composable
import androidx.compose.runtime.remember
import androidx.compose.ui.platform.LocalDensity
import com.cerve.development.ui.canvas.model.CerveCanvasGridProperties
import com.cerve.development.ui.canvas.model.CerveSize

@Composable
fun BoxWithConstraintsScope.rememberCanvasGridProperties(
    gridLineCount: Int
) : CerveCanvasGridProperties {

    val canvasSize = LocalDensity.current.run {
        CerveSize(width = maxWidth.toPx(), height = maxHeight.toPx())
    }
    return remember {
        CerveCanvasGridProperties(
            size = canvasSize,
            gridLineCount = gridLineCount
        )
    }
}