package com.cerve.development.ui.canvas.operators

import androidx.compose.runtime.Composable
import androidx.compose.runtime.saveable.Saver
import androidx.compose.runtime.saveable.listSaver
import androidx.compose.runtime.saveable.rememberSaveable
import com.cerve.development.ui.canvas.model.CerveCanvasState
import com.cerve.development.ui.canvas.model.CerveLine
import kotlinx.serialization.json.Json

val CerveDrawCanvasStateSaver: Saver<CerveCanvasState, *> = listSaver(
    save = { state ->
        val saverJson = Json { coerceInputValues = true }
        val state = saverJson.encodeToString<CerveCanvasState>(state)
        listOf(state)
    },
    restore = { list ->
        val saverJson = Json { coerceInputValues = true }
        saverJson.decodeFromString<CerveCanvasState>(list[0])
    }
)

@Composable
fun rememberCerveDrawCanvasState(
    initialLines: List<CerveLine> = emptyList(),
    initialScale: Float = 1f
) : CerveCanvasState {
    return rememberSaveable(saver = CerveDrawCanvasStateSaver) {
        CerveCanvasState(
            initialTransformations = CerveCanvasDefaults
                .canvasTransformations.copy(scale = initialScale),
            initialLines = CerveCanvasDefaults
                .canvasLines.copy(drawnLines = initialLines)
        )
    }
}
