package com.cerve.development.ui.canvas.operators

import androidx.compose.ui.geometry.Offset
import com.cerve.development.ui.canvas.model.CerveCanvasGridProperties
import com.cerve.development.ui.canvas.model.CerveLayout
import com.cerve.development.ui.canvas.model.CerveLine
import com.cerve.development.ui.canvas.model.CerveOffset

fun CerveCanvasGridProperties.generateTemplate(
    layout: CerveLayout
) : List<CerveLine> = mutableListOf<CerveLine>().apply {
    val verticalLineCount = layout.width + 1
    val horizontalLineCount = layout.length + 1

    (0 until verticalLineCount).forEach { verticalCount ->
        val x = (verticalCount * gridSpacing).toFloat()
        (0 until horizontalLineCount - 1).forEach { horizontalCount ->

            val yS = (horizontalCount * gridSpacing).toFloat()
            val yE = ((horizontalCount + 1) * gridSpacing).toFloat()

            val startOffset = CerveOffset(x = x, y = yS)
            val endOffset = CerveOffset(x = x, y = yE)

            val line = CerveLine(start = startOffset, end = endOffset)

            add(line)
        }
    }

    (0 until horizontalLineCount).forEach { horizontalCount ->
        val y =  (horizontalCount * gridSpacing).toFloat()
        (0 until verticalLineCount - 1).forEach { verticalCount ->

            val xS = ((verticalCount + 1) * gridSpacing).toFloat()
            val xE = (verticalCount * gridSpacing).toFloat()

            val startOffset = CerveOffset(x = xS, y = y)
            val endOffset = CerveOffset(x = xE, y = y)

            val line = CerveLine(start = startOffset, end = endOffset)

            add(line)
        }
    }

}

fun List<CerveLine>.adjustToCenter(
    layout: CerveLayout,
    span: Float,
    gridSpacing: Int
) : List<CerveLine> = map { line ->
    val x = (span - (layout.width * gridSpacing)).div(2)
    val y = (span - (layout.length * gridSpacing)).div(2)
    val adjustedOffset = Offset(x = x, y = y)

    line.plus(adjustedOffset)
}

fun CerveCanvasGridProperties.generateAdjustedTemplate(
    layout: CerveLayout
) : List<CerveLine> {
    return generateTemplate(layout)
        .adjustToCenter(
            layout = layout,
            span = size.span,
            gridSpacing = gridSpacing
        )
}