package com.cerve.development.ui.canvas.operators.transformation

import androidx.compose.foundation.gestures.detectTapGestures
import androidx.compose.foundation.gestures.detectTransformGestures
import androidx.compose.ui.Modifier
import androidx.compose.ui.input.pointer.pointerInput
import com.cerve.development.ui.canvas.model.CerveCanvasInteractionType
import com.cerve.development.ui.canvas.model.CerveCanvasTransformations
import com.cerve.development.ui.canvas.model.CerveOffset.Companion.offset

fun Modifier.zoomInput(
    interactionType: CerveCanvasInteractionType?,
    transformations: () -> CerveCanvasTransformations,
    onUpdateTransformations: (CerveCanvasTransformations?) -> Unit,
) = pointerInput(interactionType == CerveCanvasInteractionType.Zoom) {
    if (interactionType == CerveCanvasInteractionType.Zoom) {
        detectTransformGestures { centroid, pan, gestureZoom, rotation ->

            val zoom = transformations().scale * gestureZoom
            val compensatedPan = pan * zoom * 1f

            val position = transformations().offset.offset + compensatedPan

            val scale = transformations().scale * gestureZoom
            val rotation = transformations().rotation + rotation

            onUpdateTransformations(
                transformations().copy(
                    scale = scale,
                    rotation = rotation,
                    offset = position.offset
                )
            )
        }
    }
}.pointerInput(interactionType == CerveCanvasInteractionType.Zoom) {
    if (interactionType == CerveCanvasInteractionType.Zoom) {
        detectTapGestures(
            onLongPress = { pressPosition ->

                val scale = transformations().scale * 1.5f
                val position = (pressPosition + transformations().offset.offset) / scale

                onUpdateTransformations(
                    transformations().copy(
                        scale = scale,
                        offset = position.offset
                    )
                )
            },
            onDoubleTap = { onUpdateTransformations(null) }
        )
    }
}
