package com.cerve.development.ui.canvas.model

import androidx.compose.ui.geometry.Offset
import com.cerve.development.ui.canvas.operators.isPointInsidePolygon
import kotlinx.serialization.Serializable
import kotlinx.serialization.Transient

@Serializable
data class CerveDimensions(
    val spacing: Int,
    val detectLineBound: Boolean = false,
    @Transient val xRange: IntRange? = null,
    @Transient val yRange: IntRange? = null
) {

    constructor(spacing: Int, range: IntRange) : this(
        spacing = spacing,
        xRange = range,
        yRange = range
    )
    fun detectBounds(
        offset: Offset
    ) : Boolean {
        return if (xRange == null || yRange == null) {
            false
        } else offset.y.toInt() in yRange && offset.x.toInt() in xRange
    }

    fun detectLineBounds(
        offset: Offset,
        segments: List<CerveLine>
    ) : Boolean {
        return if (detectLineBound) {
            isPointInsidePolygon(
                point = offset,
                segments = segments
            )
        } else true
    }

    fun inBounds(
        offset: Offset,
        segments: List<CerveLine>
    ) : Boolean {
        return detectBounds(
            offset = offset
        ) && detectLineBounds(
            offset = offset,
            segments = segments
        )
    }

}
