package com.cerve.development.ui.canvas.model

import kotlinx.serialization.Serializable
import kotlin.math.roundToInt

@Serializable
data class CerveCell(
    private val topLeft: CerveOffset,
    private val cellSize: CerveSize
) {
    val offset get() = run { topLeft.offset }
    val size get() = run { cellSize.toSize }

    fun position(subgridSize: Int) : CervePosition {
        return CervePosition(
            row = topLeft.y.div(size.width).roundToInt(),
            column = topLeft.x.div(size.height).roundToInt(),
            subgridSize = subgridSize
        )
    }

}