package com.cerve.development.ui.canvas.model

import androidx.compose.ui.geometry.Offset
import kotlinx.serialization.Serializable

@Serializable
data class CerveOffset(
    val x: Float,
    val y: Float
) {
    constructor(x: Int, y: Int) : this(x.toFloat(), y.toFloat())
    val offset get() = Offset(x = x, y = y)

    fun div(other: Int) : CerveOffset = copy(x = x/other, y = y/other)

    companion object {
        val Zero = CerveOffset(0, 0)
        val Offset.offset get() = run { CerveOffset(x = x, y = y) }

    }
}
