package com.cerve.development.ui.canvas.model

import androidx.compose.ui.geometry.Offset
import kotlinx.serialization.Serializable

@Serializable
data class CervePosition(
    val row: Int,
    val column: Int,
    private val subgridSize: Int
) {
    val subgrid get() : Int = run {
        val subgridRow = row / subgridSize
        val subgridCol = column / subgridSize
        (subgridRow * subgridSize) + subgridCol
    }

    val offset get() = CerveOffset(x = column, y = row)
}
