package com.cerve.development.ui.canvas.model

import androidx.compose.ui.geometry.Size
import com.cerve.development.ui.canvas.operators.roundToFloor
import kotlinx.serialization.Serializable
import kotlin.math.pow
import com.cerve.development.ui.canvas.operators.count

@Serializable
data class CerveSize(
    private val width: Float,
    private val height: Float
) {

    constructor(width: Int, height: Int) : this(width = width.toFloat(), height = height.toFloat())
    constructor(size: Int) : this(width = size.toFloat(), height = size.toFloat())

    val maxDimension = maxOf(width, height)
    val minDimension = minOf(width, height)

    val span = run {
        val exponent = minDimension.count - 1
        val base = 10f.pow(exponent).toInt()

        minDimension.roundToFloor(base)
    }

    val offset = run {
        val x = width - span
        val y = height - span

        CerveOffset(x = x, y = y)
    }

    val center = offset.div(2)
    fun spacing(lineCount: Int) = span.div(lineCount)

    val toSize get() = run { Size(width = width, height = height) }

}
