package com.cerve.development.ui.canvas.operators

import androidx.compose.ui.geometry.Offset
import com.cerve.development.ui.canvas.model.CerveLine


// Ray Casting Algorithm
fun isPointInsidePolygon(
    point: Offset,
    segments: List<CerveLine>
): Boolean {
    var crossings = 0
    val px = point.x
    val py = point.y

    for ((p1, p2) in segments) {
        val v1x = p1.x
        val v1y = p1.y
        val v2x = p2.x
        val v2y = p2.y

        if (((v1y <= py && py < v2y) || (v2y <= py && py < v1y)) &&
            px < (v2x - v1x) * (py - v1y) / (v2y - v1y) + v1x
        ) {
            crossings++
        }
    }
    return crossings % 2 == 1
}