/*
 * Decompiled with CFR 0.152.
 */
package com.chiclaim.android.downloader;

import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import com.chiclaim.android.downloader.DownloadException;
import com.chiclaim.android.downloader.DownloadExecutor;
import com.chiclaim.android.downloader.DownloadInfo;
import com.chiclaim.android.downloader.DownloadObserver;
import com.chiclaim.android.downloader.DownloadRequest;
import com.chiclaim.android.downloader.Downloader;
import com.chiclaim.android.downloader.R;
import com.chiclaim.android.downloader.SystemDownloadManager;
import com.chiclaim.android.downloader.util.Utils;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/chiclaim/android/downloader/DownloadObserver;", "Landroid/database/ContentObserver;", "context", "Landroid/content/Context;", "downloadId", "", "downloader", "Lcom/chiclaim/android/downloader/Downloader;", "(Landroid/content/Context;JLcom/chiclaim/android/downloader/Downloader;)V", "handler", "Landroid/os/Handler;", "getHandler", "()Landroid/os/Handler;", "handler$delegate", "Lkotlin/Lazy;", "onChange", "", "selfChange", "", "downloader_release"})
public final class DownloadObserver
extends ContentObserver {
    private final long downloadId;
    @NotNull
    private Downloader downloader;
    @NotNull
    private final Context context;
    @NotNull
    private final Lazy handler$delegate;

    public DownloadObserver(@NotNull Context context, long downloadId, @NotNull Downloader downloader2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)downloader2, (String)"downloader");
        super(null);
        this.downloadId = downloadId;
        this.downloader = downloader2;
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        this.context = context2;
        this.handler$delegate = LazyKt.lazy((Function0)handler.2.INSTANCE);
    }

    private final Handler getHandler() {
        Lazy lazy = this.handler$delegate;
        return (Handler)lazy.getValue();
    }

    public void onChange(boolean selfChange) {
        super.onChange(selfChange);
        DownloadExecutor.Companion.execute(() -> DownloadObserver.onChange$lambda-1(this));
    }

    private static final void onChange$lambda-1$lambda-0(DownloadObserver this$0, DownloadInfo $info) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$info, (String)"$info");
        this$0.downloader.getRequest$downloader_release().onProgressUpdate$downloader_release(Utils.INSTANCE.getPercent$downloader_release($info.getTotalSize(), $info.getDownloadedSize()));
        switch ($info.getStatus()) {
            case 8: {
                this$0.context.getContentResolver().unregisterContentObserver((ContentObserver)this$0);
                Uri uri = $info.getUri();
                if (uri == null) {
                    DownloadRequest downloadRequest = this$0.downloader.getRequest$downloader_release();
                    String string2 = this$0.context.getString(R.string.downloader_notifier_failed_missing_uri);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.stri\u2026ifier_failed_missing_uri)");
                    downloadRequest.onFailed$downloader_release(new DownloadException(4, string2, 0, 4, null));
                    break;
                }
                this$0.downloader.getRequest$downloader_release().onComplete$downloader_release(uri);
                break;
            }
            case 16: {
                this$0.context.getContentResolver().unregisterContentObserver((ContentObserver)this$0);
                DownloadRequest downloadRequest = this$0.downloader.getRequest$downloader_release();
                Context context = this$0.context;
                Object[] objectArray = new Object[1];
                String string3 = $info.getReason();
                if (string3 == null) {
                    string3 = "-";
                }
                objectArray[0] = string3;
                String string4 = context.getString(R.string.downloader_notifier_content_err_placeholder, objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"context.getString(\n     \u2026                        )");
                downloadRequest.onFailed$downloader_release(new DownloadException(3, string4, 0, 4, null));
            }
        }
    }

    private static final void onChange$lambda-1(DownloadObserver this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        DownloadInfo downloadInfo = new SystemDownloadManager(this$0.context).getDownloadInfo(this$0.downloadId);
        if (downloadInfo == null) {
            return;
        }
        DownloadInfo info = downloadInfo;
        this$0.getHandler().post(() -> DownloadObserver.onChange$lambda-1$lambda-0(this$0, info));
    }
}

