/*
 * Decompiled with CFR 0.152.
 */
package com.chiclaim.android.downloader;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.DrawableRes;
import com.chiclaim.android.downloader.DownloadListener;
import com.chiclaim.android.downloader.Downloader;
import com.chiclaim.android.downloader.DownloaderManager;
import com.chiclaim.android.downloader.EmbedDownloader;
import com.chiclaim.android.downloader.R;
import com.chiclaim.android.downloader.SystemDownloader;
import com.chiclaim.android.downloader.util.Utils;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u0003\n\u0002\b\u001d\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010+\u001a\u00020,2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\r\u0010-\u001a\u00020.H\u0000\u00a2\u0006\u0002\b/J\u0013\u00100\u001a\u00020\u00122\b\u00101\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u00102\u001a\u00020\u0005H\u0002J\b\u00103\u001a\u00020\u0007H\u0016J\b\u00104\u001a\u00020.H\u0002J\u0015\u00105\u001a\u00020.2\u0006\u00106\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b7J\u0015\u00108\u001a\u00020.2\u0006\u00109\u001a\u00020:H\u0000\u00a2\u0006\u0002\b;J\u0015\u0010<\u001a\u00020.2\u0006\u0010=\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b>J\r\u0010?\u001a\u00020.H\u0000\u00a2\u0006\u0002\b@J\u000e\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u00020\u001aJ\u000e\u0010C\u001a\u00020\u00002\u0006\u00106\u001a\u00020\fJ\u0015\u0010D\u001a\u00020\u00002\u0006\u0010E\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\bFJ\u000e\u0010G\u001a\u00020\u00002\u0006\u0010H\u001a\u00020\u0012J\u000e\u0010I\u001a\u00020\u00002\u0006\u0010J\u001a\u00020\u0012J\u000e\u0010K\u001a\u00020\u00002\u0006\u0010L\u001a\u00020\u001dJ\u0010\u0010M\u001a\u00020\u00002\b\b\u0001\u0010N\u001a\u00020\u0007J\u000e\u0010O\u001a\u00020\u00002\u0006\u0010P\u001a\u00020\u001dJ\u000e\u0010Q\u001a\u00020\u00002\u0006\u0010R\u001a\u00020\u0007J\u000e\u0010S\u001a\u00020\u00002\u0006\u0010T\u001a\u00020\u0012J\u0006\u0010U\u001a\u00020\u0012J\u000e\u0010V\u001a\u00020.2\u0006\u0010B\u001a\u00020\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR$\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f8F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0012@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0016\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0015R\"\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\b\u0010\u000b\u001a\u0004\u0018\u00010\u001d@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R \u0010!\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00078F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0011R$\u0010#\u001a\u0004\u0018\u00010\u001d2\b\u0010\u000b\u001a\u0004\u0018\u00010\u001d8F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010 R\u001e\u0010%\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0011R\u001e\u0010'\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u0006W"}, d2={"Lcom/chiclaim/android/downloader/DownloadRequest;", "", "context", "Landroid/content/Context;", "url", "", "engine", "", "(Landroid/content/Context;Ljava/lang/String;I)V", "getContext", "()Landroid/content/Context;", "<set-?>", "Landroid/net/Uri;", "destinationUri", "getDestinationUri", "()Landroid/net/Uri;", "getEngine", "()I", "", "fromNotifier", "getFromNotifier$downloader_release", "()Z", "ignoreLocal", "getIgnoreLocal", "listeners", "", "Lcom/chiclaim/android/downloader/DownloadListener;", "needInstall", "getNeedInstall", "", "notificationContent", "getNotificationContent", "()Ljava/lang/CharSequence;", "notificationSmallIcon", "getNotificationSmallIcon", "notificationTitle", "getNotificationTitle", "notificationVisibility", "getNotificationVisibility", "showNotificationDisableTip", "getShowNotificationDisableTip", "getUrl", "()Ljava/lang/String;", "createDownloader", "Lcom/chiclaim/android/downloader/Downloader;", "download", "", "download$downloader_release", "equals", "other", "getDefaultTitle", "hashCode", "initListenerList", "onComplete", "uri", "onComplete$downloader_release", "onFailed", "e", "", "onFailed$downloader_release", "onProgressUpdate", "percent", "onProgressUpdate$downloader_release", "onStart", "onStart$downloader_release", "registerListener", "listener", "setDestinationUri", "setFromNotifier", "isFromNotifier", "setFromNotifier$downloader_release", "setIgnoreLocal", "ignore", "setNeedInstall", "need", "setNotificationContent", "content", "setNotificationSmallIcon", "smallIcon", "setNotificationTitle", "title", "setNotificationVisibility", "visibility", "setShowNotificationDisableTip", "show", "startDownload", "unregisterListener", "downloader_release"})
public final class DownloadRequest {
    @NotNull
    private final Context context;
    @NotNull
    private final String url;
    private final int engine;
    @Nullable
    private Uri destinationUri;
    private boolean ignoreLocal;
    private boolean needInstall;
    private int notificationVisibility;
    private int notificationSmallIcon;
    @Nullable
    private CharSequence notificationTitle;
    @Nullable
    private CharSequence notificationContent;
    private boolean showNotificationDisableTip;
    private boolean fromNotifier;
    @Nullable
    private Set<DownloadListener> listeners;

    public DownloadRequest(@NotNull Context context, @NotNull String url, int engine) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.context = context;
        this.url = url;
        this.engine = engine;
        this.notificationVisibility = 1;
        this.notificationSmallIcon = -1;
    }

    public /* synthetic */ DownloadRequest(Context context, String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, string, n);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    public final int getEngine() {
        return this.engine;
    }

    @Nullable
    public final Uri getDestinationUri() {
        return this.destinationUri == null ? Uri.fromFile((File)new File(Utils.INSTANCE.getDownloadDir(this.context), StringsKt.substringAfterLast$default((String)this.url, (String)"/", null, (int)2, null))) : this.destinationUri;
    }

    public final boolean getIgnoreLocal() {
        return this.ignoreLocal;
    }

    public final boolean getNeedInstall() {
        return this.needInstall;
    }

    public final int getNotificationVisibility() {
        return this.notificationVisibility;
    }

    public final int getNotificationSmallIcon() {
        return this.notificationSmallIcon == -1 ? this.context.getApplicationInfo().icon : this.notificationSmallIcon;
    }

    @Nullable
    public final CharSequence getNotificationTitle() {
        return this.notificationTitle == null ? (CharSequence)this.getDefaultTitle() : this.notificationTitle;
    }

    @Nullable
    public final CharSequence getNotificationContent() {
        return this.notificationContent;
    }

    public final boolean getShowNotificationDisableTip() {
        return this.showNotificationDisableTip;
    }

    public final boolean getFromNotifier$downloader_release() {
        return this.fromNotifier;
    }

    @NotNull
    public final DownloadRequest setFromNotifier$downloader_release(boolean isFromNotifier) {
        this.fromNotifier = isFromNotifier;
        return this;
    }

    @NotNull
    public final DownloadRequest setDestinationUri(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.destinationUri = uri;
        return this;
    }

    @NotNull
    public final DownloadRequest setShowNotificationDisableTip(boolean show) {
        this.showNotificationDisableTip = show;
        return this;
    }

    @NotNull
    public final DownloadRequest setNotificationSmallIcon(@DrawableRes int smallIcon) {
        this.notificationSmallIcon = smallIcon;
        return this;
    }

    @NotNull
    public final DownloadRequest setIgnoreLocal(boolean ignore) {
        this.ignoreLocal = ignore;
        return this;
    }

    @NotNull
    public final DownloadRequest setNeedInstall(boolean need) {
        this.needInstall = need;
        return this;
    }

    @NotNull
    public final DownloadRequest setNotificationTitle(@NotNull CharSequence title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.notificationTitle = title;
        return this;
    }

    @NotNull
    public final DownloadRequest setNotificationContent(@NotNull CharSequence content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.notificationContent = content;
        return this;
    }

    @NotNull
    public final DownloadRequest setNotificationVisibility(int visibility) {
        this.notificationVisibility = visibility;
        return this;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DownloadRequest)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.url, (Object)((DownloadRequest)other).url);
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    private final String getDefaultTitle() {
        Object[] objectArray = new Object[]{this.context.getApplicationInfo().loadLabel(this.context.getPackageManager())};
        String string2 = this.context.getString(R.string.downloader_notifier_title_placeholder, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(\n     \u2026packageManager)\n        )");
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initListenerList() {
        if (this.listeners == null) {
            synchronized (this) {
                boolean bl = false;
                if (this.listeners == null) {
                    this.listeners = new LinkedHashSet();
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @NotNull
    public final DownloadRequest registerListener(@NotNull DownloadListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.initListenerList();
        Set<DownloadListener> set = this.listeners;
        if (set != null) {
            set.add(listener);
        }
        return this;
    }

    public final void unregisterListener(@NotNull DownloadListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (this.listeners == null) {
            return;
        }
        Set<DownloadListener> set = this.listeners;
        if (set != null) {
            set.remove(listener);
        }
    }

    public final void onStart$downloader_release() {
        Set<DownloadListener> set = this.listeners;
        if (set != null) {
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DownloadListener it = (DownloadListener)element$iv;
                boolean bl = false;
                it.onDownloadStart();
            }
        }
    }

    public final void onComplete$downloader_release(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Set<DownloadListener> set = this.listeners;
        if (set != null) {
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DownloadListener it = (DownloadListener)element$iv;
                boolean bl = false;
                it.onDownloadComplete(uri);
            }
        }
        DownloadRequest[] downloadRequestArray = new DownloadRequest[]{this};
        DownloaderManager.INSTANCE.remove(downloadRequestArray);
        Set<DownloadListener> set2 = this.listeners;
        if (set2 != null) {
            set2.clear();
        }
    }

    public final void onFailed$downloader_release(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Set<DownloadListener> set = this.listeners;
        if (set != null) {
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DownloadListener it = (DownloadListener)element$iv;
                boolean bl = false;
                it.onDownloadFailed(e);
            }
        }
        DownloadRequest[] downloadRequestArray = new DownloadRequest[]{this};
        DownloaderManager.INSTANCE.remove(downloadRequestArray);
        Set<DownloadListener> set2 = this.listeners;
        if (set2 != null) {
            set2.clear();
        }
    }

    public final void onProgressUpdate$downloader_release(int percent) {
        Set<DownloadListener> set = this.listeners;
        if (set != null) {
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DownloadListener it = (DownloadListener)element$iv;
                boolean bl = false;
                it.onProgressUpdate(percent);
            }
        }
    }

    private final Downloader createDownloader(int engine) {
        return engine == 1 ? (Downloader)new SystemDownloader(this) : (Downloader)new EmbedDownloader(this);
    }

    public final void download$downloader_release() {
        Downloader downloader2 = this.createDownloader(this.engine);
        downloader2.download$downloader_release();
    }

    public final boolean startDownload() {
        if (DownloaderManager.INSTANCE.isRunning(this)) {
            return false;
        }
        if (this.notificationVisibility != 2 && this.showNotificationDisableTip) {
            Utils.INSTANCE.checkNotificationsEnabled(this.context);
        }
        Downloader downloader2 = this.createDownloader(this.engine);
        downloader2.startDownload();
        return true;
    }
}

