/*
 * Decompiled with CFR 0.152.
 */
package com.chiclaim.android.downloader;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.SystemClock;
import com.chiclaim.android.downloader.DownloadException;
import com.chiclaim.android.downloader.DownloadExecutor;
import com.chiclaim.android.downloader.DownloadRecord;
import com.chiclaim.android.downloader.DownloadRequest;
import com.chiclaim.android.downloader.Downloader;
import com.chiclaim.android.downloader.EmbedDownloader;
import com.chiclaim.android.downloader.R;
import com.chiclaim.android.downloader.util.InstallUtils;
import com.chiclaim.android.downloader.util.MD5;
import com.chiclaim.android.downloader.util.NotifierUtils;
import com.chiclaim.android.downloader.util.Utils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 '2\u00020\u0001:\u0001'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\fH\u0002J\r\u0010\u001d\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\b\u001eJ\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0010H\u0002J\u001a\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u001c\u001a\u00020\fH\u0002J\b\u0010%\u001a\u00020\u0019H\u0002J\u0010\u0010&\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/chiclaim/android/downloader/EmbedDownloader;", "Lcom/chiclaim/android/downloader/Downloader;", "request", "Lcom/chiclaim/android/downloader/DownloadRequest;", "(Lcom/chiclaim/android/downloader/DownloadRequest;)V", "handler", "Landroid/os/Handler;", "getHandler", "()Landroid/os/Handler;", "handler$delegate", "Lkotlin/Lazy;", "lastNotifyTime", "", "callFailed", "", "record", "Lcom/chiclaim/android/downloader/DownloadRecord;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "callPercent", "percent", "", "callSuccessful", "destinationFile", "Ljava/io/File;", "checkComplete", "", "currentLength", "download", "download$downloader_release", "fillRequestFromDB", "dbRecord", "prepareConnection", "Ljava/net/HttpURLConnection;", "uri", "Ljava/net/URL;", "prepareDestinationFile", "prepareRecord", "Companion", "downloader_release"})
public final class EmbedDownloader
extends Downloader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy handler$delegate;
    private long lastNotifyTime;
    private static final int HTTP_TEMP_REDIRECT = 307;
    private static final int HTTP_PERM_REDIRECT = 308;
    private static final int HTTP_REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    private static final int MAX_REDIRECTS = 5;

    public EmbedDownloader(@NotNull DownloadRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        super(request);
        this.handler$delegate = LazyKt.lazy((Function0)handler.2.INSTANCE);
    }

    private final Handler getHandler() {
        Lazy lazy = this.handler$delegate;
        return (Handler)lazy.getValue();
    }

    private final HttpURLConnection prepareConnection(URL uri, long currentLength) {
        boolean resuming;
        URL uRL = uri;
        if (uRL == null) {
            uRL = new URL(this.getRequest$downloader_release().getUrl());
        }
        URL url = uRL;
        URLConnection uRLConnection = url.openConnection();
        if (uRLConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection conn = (HttpURLConnection)uRLConnection;
        conn.setRequestMethod("GET");
        conn.setConnectTimeout(10000);
        conn.setRequestProperty("Accept-Encoding", "identity");
        if (conn.getRequestProperty("User-Agent") == null) {
            conn.addRequestProperty("User-Agent", "AndroidDownloader/1.0");
        }
        boolean bl = resuming = !this.getRequest$downloader_release().getIgnoreLocal() && currentLength > 0L;
        if (resuming) {
            conn.setRequestProperty("Range", "bytes=" + currentLength + '-');
        }
        return conn;
    }

    private final File prepareDestinationFile() {
        String string2;
        Uri uri = this.getRequest$downloader_release().getDestinationUri();
        String string3 = string2 = uri == null ? null : uri.getPath();
        if (string2 == null) {
            throw new NullPointerException("request must set destinationDir path");
        }
        File file = new File(string2);
        if (file.isDirectory()) {
            String $this$prepareDestinationFile_u24lambda_u2d0 = StringsKt.substringAfterLast((String)this.getRequest$downloader_release().getUrl(), (String)".", (String)"");
            boolean bl = false;
            String ext = $this$prepareDestinationFile_u24lambda_u2d0.length() > 10 ? "" : Intrinsics.stringPlus((String)".", (Object)$this$prepareDestinationFile_u24lambda_u2d0);
            return new File(file, Intrinsics.stringPlus((String)MD5.INSTANCE.md5(this.getRequest$downloader_release().getUrl()), (Object)ext));
        }
        return file;
    }

    private final void fillRequestFromDB(DownloadRecord dbRecord) {
        String it;
        String string2 = dbRecord.getNotificationTitle();
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            this.getRequest$downloader_release().setNotificationTitle(it);
        }
        String string3 = dbRecord.getNotificationContent();
        if (string3 != null) {
            it = string3;
            boolean bl = false;
            this.getRequest$downloader_release().setNotificationContent(it);
        }
        String string4 = dbRecord.getDestinationUri();
        if (string4 != null) {
            it = string4;
            boolean bl = false;
            DownloadRequest downloadRequest = this.getRequest$downloader_release();
            Uri uri = Uri.parse((String)it);
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(it)");
            downloadRequest.setDestinationUri(uri);
        }
        this.getRequest$downloader_release().setIgnoreLocal(dbRecord.getIgnoreLocal());
        this.getRequest$downloader_release().setNeedInstall(dbRecord.getNeedInstall());
        this.getRequest$downloader_release().setNotificationVisibility(dbRecord.getNotificationVisibility());
    }

    private final DownloadRecord prepareRecord(File destinationFile) {
        DownloadRecord downloadRecord;
        DownloadRecord inputRecord = null;
        String string2 = this.getRequest$downloader_release().getUrl();
        String string3 = destinationFile.getName();
        String string4 = destinationFile.getAbsolutePath();
        boolean bl = this.getRequest$downloader_release().getIgnoreLocal();
        boolean bl2 = this.getRequest$downloader_release().getNeedInstall();
        String string5 = String.valueOf(this.getRequest$downloader_release().getNotificationTitle());
        String string6 = String.valueOf(this.getRequest$downloader_release().getNotificationContent());
        int n = this.getRequest$downloader_release().getNotificationVisibility();
        inputRecord = new DownloadRecord(0L, string2, string3, string4, bl, bl2, n, string5, string6, 0L, 2, 513, null);
        DownloadRecord $this$prepareRecord_u24lambda_u2d4 = (DownloadRecord)CollectionsKt.firstOrNull(inputRecord.queryByUrl(this.getRequest$downloader_release().getContext()));
        boolean bl3 = false;
        if ($this$prepareRecord_u24lambda_u2d4 == null) {
            long rowId = inputRecord.insert(this.getRequest$downloader_release().getContext());
            if (rowId != -1L) {
                downloadRecord = (DownloadRecord)CollectionsKt.firstOrNull(inputRecord.queryByUrl(this.getRequest$downloader_release().getContext()));
                if (downloadRecord == null) {
                    downloadRecord = inputRecord;
                }
            } else {
                downloadRecord = inputRecord;
            }
        } else if (this.getRequest$downloader_release().getFromNotifier$downloader_release()) {
            this.fillRequestFromDB($this$prepareRecord_u24lambda_u2d4);
            $this$prepareRecord_u24lambda_u2d4.setStatus(2);
            downloadRecord = $this$prepareRecord_u24lambda_u2d4;
        } else {
            inputRecord.setId($this$prepareRecord_u24lambda_u2d4.getId());
            inputRecord.setTotalBytes($this$prepareRecord_u24lambda_u2d4.getTotalBytes());
            downloadRecord = inputRecord;
        }
        inputRecord = downloadRecord;
        return inputRecord;
    }

    private final boolean checkComplete(DownloadRecord record, long currentLength) {
        return !record.getIgnoreLocal() && record.getTotalBytes() > 0L && record.getTotalBytes() == currentLength;
    }

    private final void callPercent(int percent) {
        this.getHandler().post(() -> EmbedDownloader.callPercent$lambda-5(this, percent));
    }

    private final void callSuccessful(DownloadRecord record, File destinationFile) {
        record.setStatus(8);
        record.update(this.getRequest$downloader_release().getContext());
        this.getHandler().post(() -> EmbedDownloader.callSuccessful$lambda-6(this, destinationFile, record));
    }

    private final void callFailed(DownloadRecord record, Exception e) {
        DownloadRecord downloadRecord = record;
        if (downloadRecord != null) {
            DownloadRecord it = downloadRecord;
            boolean bl = false;
            it.setStatus(16);
            it.update(this.getRequest$downloader_release().getContext());
        }
        this.getHandler().post(() -> EmbedDownloader.callFailed$lambda-8(this, e));
    }

    @Override
    public void download$downloader_release() {
        DownloadExecutor.Companion.execute(() -> EmbedDownloader.download$lambda-12(this));
    }

    private static final void callPercent$lambda-5(EmbedDownloader this$0, int $percent) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.getRequest$downloader_release().onProgressUpdate$downloader_release($percent);
        if (this$0.getRequest$downloader_release().getNotificationVisibility() == 1 || this$0.getRequest$downloader_release().getNotificationVisibility() == 0) {
            Context context = this$0.getRequest$downloader_release().getContext();
            int n = this$0.getRequest$downloader_release().getUrl().hashCode();
            int n2 = this$0.getRequest$downloader_release().getNotificationSmallIcon();
            CharSequence charSequence = this$0.getRequest$downloader_release().getNotificationTitle();
            if (charSequence == null) {
                charSequence = "";
            }
            NotifierUtils.Companion.showNotification$default(NotifierUtils.Companion, context, n, n2, $percent, charSequence, this$0.getRequest$downloader_release().getNotificationContent(), 2, null, null, 384, null);
        }
    }

    private static final void callSuccessful$lambda-6(EmbedDownloader this$0, File $destinationFile, DownloadRecord $record) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$destinationFile, (String)"$destinationFile");
        Intrinsics.checkNotNullParameter((Object)$record, (String)"$record");
        switch (this$0.getRequest$downloader_release().getNotificationVisibility()) {
            case 1: 
            case 3: {
                Context context = this$0.getRequest$downloader_release().getContext();
                int n = this$0.getRequest$downloader_release().getUrl().hashCode();
                int n2 = this$0.getRequest$downloader_release().getNotificationSmallIcon();
                CharSequence charSequence = this$0.getRequest$downloader_release().getNotificationTitle();
                if (charSequence == null) {
                    charSequence = "";
                }
                NotifierUtils.Companion.showNotification$default(NotifierUtils.Companion, context, n, n2, 100, charSequence, this$0.getRequest$downloader_release().getContext().getString(R.string.downloader_notifier_success_to_install), 8, $destinationFile, null, 256, null);
                break;
            }
            case 0: {
                NotifierUtils.Companion.cancelNotification(this$0.getRequest$downloader_release().getContext(), this$0.getRequest$downloader_release().getUrl().hashCode());
            }
        }
        DownloadRequest downloadRequest = this$0.getRequest$downloader_release();
        Uri uri = Uri.fromFile((File)$destinationFile);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"fromFile(destinationFile)");
        downloadRequest.onComplete$downloader_release(uri);
        if ($record.getNeedInstall()) {
            InstallUtils.startInstall(this$0.getRequest$downloader_release().getContext(), $destinationFile);
        }
    }

    private static final void callFailed$lambda-8(EmbedDownloader this$0, Exception $e) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
        if (this$0.getRequest$downloader_release().getNotificationVisibility() != 2) {
            Context context = this$0.getRequest$downloader_release().getContext();
            int n = this$0.getRequest$downloader_release().getUrl().hashCode();
            int n2 = this$0.getRequest$downloader_release().getNotificationSmallIcon();
            CharSequence charSequence = this$0.getRequest$downloader_release().getNotificationTitle();
            if (charSequence == null) {
                charSequence = "";
            }
            NotifierUtils.Companion.showNotification$default(NotifierUtils.Companion, context, n, n2, -1, charSequence, Utils.INSTANCE.getTipFromException(this$0.getRequest$downloader_release().getContext(), $e), 16, null, this$0.getRequest$downloader_release().getUrl(), 128, null);
        }
        this$0.getRequest$downloader_release().onFailed$downloader_release($e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void download$lambda-12$writeFile(long currentLength, Ref.ObjectRef<HttpURLConnection> conn, EmbedDownloader this$0, Ref.ObjectRef<DownloadRecord> record, File destinationFile, boolean append) {
        long wroteLength = 0L;
        wroteLength = append ? currentLength : 0L;
        Closeable closeable = ((HttpURLConnection)conn.element).getInputStream();
        Throwable throwable = null;
        try {
            InputStream input = (InputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new FileOutputStream(destinationFile, append);
            Throwable throwable2 = null;
            try {
                FileOutputStream fos = (FileOutputStream)closeable2;
                boolean bl2 = false;
                byte[] data = new byte[8192];
                int count = 0;
                while (true) {
                    int n;
                    int len = n = input.read(data);
                    boolean bl3 = false;
                    count = len;
                    if (n == -1) break;
                    fos.write(data, 0, count);
                    fos.flush();
                    long now = SystemClock.elapsedRealtime();
                    long notifyInterval = now - this$0.lastNotifyTime;
                    if (notifyInterval <= 700L && ((DownloadRecord)record.element).getTotalBytes() != (wroteLength += (long)count)) continue;
                    int percent = Utils.INSTANCE.getPercent$downloader_release(((DownloadRecord)record.element).getTotalBytes(), wroteLength);
                    this$0.callPercent(percent);
                    this$0.lastNotifyTime = now;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this$0.callSuccessful((DownloadRecord)record.element, destinationFile);
    }

    static /* synthetic */ void download$lambda-12$writeFile$default(long l, Ref.ObjectRef objectRef, EmbedDownloader embedDownloader, Ref.ObjectRef objectRef2, File file, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        EmbedDownloader.download$lambda-12$writeFile(l, (Ref.ObjectRef<HttpURLConnection>)objectRef, embedDownloader, (Ref.ObjectRef<DownloadRecord>)objectRef2, file, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void download$lambda-12(EmbedDownloader this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        URL url = null;
        Ref.ObjectRef conn = new Ref.ObjectRef();
        int redirectCount = 0;
        block14: while (true) {
            Ref.ObjectRef record = new Ref.ObjectRef();
            try {
                boolean bl;
                long currentLength;
                if (redirectCount >= 5) {
                    throw new DownloadException(5, "too many redirect times", 0, 4, null);
                }
                File destinationFile = this$0.prepareDestinationFile();
                record.element = this$0.prepareRecord(destinationFile);
                long l = currentLength = destinationFile.exists() ? destinationFile.length() : 0L;
                if (this$0.checkComplete((DownloadRecord)record.element, currentLength)) {
                    this$0.callSuccessful((DownloadRecord)record.element, destinationFile);
                    return;
                }
                conn.element = this$0.prepareConnection(url, currentLength);
                String string2 = ((HttpURLConnection)conn.element).getRequestProperty("Range");
                boolean resuming = string2 == null ? false : (bl = ((CharSequence)string2).length() > 0);
                switch (((HttpURLConnection)conn.element).getResponseCode()) {
                    case 200: {
                        if (resuming) {
                            throw new DownloadException(6, "Expected partial, but received OK", 0, 4, null);
                        }
                        ((DownloadRecord)record.element).setTotalBytes(((HttpURLConnection)conn.element).getContentLength());
                        ((DownloadRecord)record.element).update(this$0.getRequest$downloader_release().getContext());
                        EmbedDownloader.download$lambda-12$writeFile$default(currentLength, conn, this$0, record, destinationFile, false, 32, null);
                        return;
                    }
                    case 206: {
                        if (!resuming) {
                            throw new DownloadException(6, "Expected OK, but received partial", 0, 4, null);
                        }
                        EmbedDownloader.download$lambda-12$writeFile(currentLength, (Ref.ObjectRef<HttpURLConnection>)conn, this$0, (Ref.ObjectRef<DownloadRecord>)record, destinationFile, true);
                        return;
                    }
                    case 301: 
                    case 302: 
                    case 303: 
                    case 307: 
                    case 308: {
                        ((HttpURLConnection)conn.element).disconnect();
                        String string3 = ((HttpURLConnection)conn.element).getHeaderField("Location");
                        if (string3 == null) {
                            throw new DownloadException(7, "missing Location in redirect", 0, 4, null);
                        }
                        String locationUrl = string3;
                        url = new URL(url, locationUrl);
                        int n = redirectCount;
                        redirectCount = n + 1;
                        continue block14;
                    }
                    case 416: {
                        ((HttpURLConnection)conn.element).disconnect();
                        ((DownloadRecord)record.element).delete(this$0.getRequest$downloader_release().getContext());
                        this$0.getRequest$downloader_release().setIgnoreLocal(true);
                        continue block14;
                    }
                    default: {
                        throw new DownloadException(8, Intrinsics.stringPlus((String)"Download Failed: ", (Object)((HttpURLConnection)conn.element).getResponseCode()), ((HttpURLConnection)conn.element).getResponseCode());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this$0.callFailed((DownloadRecord)record.element, e);
                return;
            }
            finally {
                HttpURLConnection httpURLConnection = (HttpURLConnection)conn.element;
                if (httpURLConnection == null) continue;
                httpURLConnection.disconnect();
                continue;
            }
            break;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/chiclaim/android/downloader/EmbedDownloader$Companion;", "", "()V", "HTTP_PERM_REDIRECT", "", "HTTP_REQUESTED_RANGE_NOT_SATISFIABLE", "HTTP_TEMP_REDIRECT", "MAX_REDIRECTS", "downloader_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

