/*
 * Decompiled with CFR 0.152.
 */
package com.chiclaim.android.downloader;

import android.app.DownloadManager;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import com.chiclaim.android.downloader.DownloadInfo;
import com.chiclaim.android.downloader.util.SpHelper;
import java.io.Closeable;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000eJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0013\u001a\u00020\u000eJ\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u000eJ\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0013\u001a\u00020\u000eJ\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u000eR\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/chiclaim/android/downloader/SystemDownloadManager;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "downloadManager", "Landroid/app/DownloadManager;", "getDownloadManager", "()Landroid/app/DownloadManager;", "downloadManager$delegate", "Lkotlin/Lazy;", "clearLocalDownloadIds", "", "download", "", "request", "Landroid/app/DownloadManager$Request;", "getDownloadInfo", "Lcom/chiclaim/android/downloader/DownloadInfo;", "downloadId", "getDownloadLocalUri", "", "getDownloadPath", "getDownloadStatus", "", "getDownloadedFileUri", "Landroid/net/Uri;", "removeTask", "downloader_release"})
public final class SystemDownloadManager {
    @NotNull
    private final Lazy downloadManager$delegate;

    public SystemDownloadManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.downloadManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DownloadManager>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final DownloadManager invoke() {
                Object object = this.$context.getSystemService("download");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.app.DownloadManager");
                }
                return (DownloadManager)object;
            }
        }));
    }

    private final DownloadManager getDownloadManager() {
        Lazy lazy = this.downloadManager$delegate;
        return (DownloadManager)lazy.getValue();
    }

    public final long download(@NotNull DownloadManager.Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.getDownloadManager().enqueue(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getDownloadPath(long downloadId) {
        Cursor c;
        long[] lArray = new long[]{downloadId};
        DownloadManager.Query query = new DownloadManager.Query().setFilterById(lArray);
        Cursor cursor = c = this.getDownloadManager().query(query);
        if (cursor != null) {
            Closeable closeable = (Closeable)cursor;
            Throwable throwable = null;
            try {
                Cursor it = (Cursor)closeable;
                boolean bl = false;
                if (c.moveToFirst()) {
                    String string2 = c.getString(c.getColumnIndex("local_uri"));
                    return string2;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return null;
    }

    @Nullable
    public final Uri getDownloadedFileUri(long downloadId) {
        return this.getDownloadManager().getUriForDownloadedFile(downloadId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getDownloadStatus(long downloadId) {
        Cursor c;
        long[] lArray = new long[]{downloadId};
        DownloadManager.Query query = new DownloadManager.Query().setFilterById(lArray);
        Cursor cursor = c = this.getDownloadManager().query(query);
        if (cursor != null) {
            Closeable closeable = (Closeable)cursor;
            Throwable throwable = null;
            try {
                Cursor it = (Cursor)closeable;
                boolean bl = false;
                if (it.moveToFirst()) {
                    int n = c.getInt(c.getColumnIndex("status"));
                    return n;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return -1;
    }

    public final int removeTask(long downloadId) {
        long[] lArray = new long[]{downloadId};
        return this.getDownloadManager().remove(lArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String getDownloadLocalUri(long downloadId) {
        Cursor c;
        long[] lArray = new long[]{downloadId};
        DownloadManager.Query query = new DownloadManager.Query().setFilterById(lArray);
        Cursor cursor = c = this.getDownloadManager().query(query);
        if (cursor != null) {
            Closeable closeable = (Closeable)cursor;
            Throwable throwable = null;
            try {
                int index;
                Cursor it = (Cursor)closeable;
                boolean bl = false;
                if (c.moveToFirst() && (index = c.getColumnIndex("local_uri")) != -1) {
                    String string2 = c.getString(index);
                    return string2;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final DownloadInfo getDownloadInfo(long downloadId) {
        Cursor c;
        long[] lArray = new long[]{downloadId};
        DownloadManager.Query query = new DownloadManager.Query().setFilterById(lArray);
        Cursor cursor = c = this.getDownloadManager().query(query);
        if (cursor != null) {
            Closeable closeable = (Closeable)cursor;
            Throwable throwable = null;
            try {
                Cursor it = (Cursor)closeable;
                boolean bl = false;
                if (c.moveToFirst()) {
                    DownloadInfo info = new DownloadInfo(downloadId);
                    int index = c.getColumnIndex("bytes_so_far");
                    if (index != -1) {
                        info.setDownloadedSize(c.getLong(index));
                    }
                    if ((index = c.getColumnIndex("total_size")) != -1) {
                        info.setTotalSize(c.getLong(index));
                    }
                    if ((index = c.getColumnIndex("status")) != -1) {
                        info.setStatus(c.getInt(index));
                    }
                    if (info.getStatus() == 16 && (index = c.getColumnIndex("reason")) != -1) {
                        info.setReason(c.getString(index));
                    }
                    if ((index = c.getColumnIndex("local_uri")) != -1) {
                        String string2 = c.getString(index);
                        if (string2 != null) {
                            String it2 = string2;
                            boolean bl2 = false;
                            info.setUri(Uri.parse((String)it2));
                        }
                    }
                    DownloadInfo downloadInfo = info;
                    return downloadInfo;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return null;
    }

    public final void clearLocalDownloadIds(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SpHelper.Companion.get(context).clear();
    }
}

