/*
 * Decompiled with CFR 0.152.
 */
package com.chiclaim.android.downloader;

import android.app.DownloadManager;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.widget.Toast;
import com.chiclaim.android.downloader.DownloadConstants;
import com.chiclaim.android.downloader.DownloadInfo;
import com.chiclaim.android.downloader.DownloadObserver;
import com.chiclaim.android.downloader.DownloadRequest;
import com.chiclaim.android.downloader.Downloader;
import com.chiclaim.android.downloader.R;
import com.chiclaim.android.downloader.SystemDownloadManager;
import com.chiclaim.android.downloader.util.InstallUtils;
import com.chiclaim.android.downloader.util.Utils;
import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\r\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\b\u000fJ\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/chiclaim/android/downloader/SystemDownloader;", "Lcom/chiclaim/android/downloader/Downloader;", "request", "Lcom/chiclaim/android/downloader/DownloadRequest;", "(Lcom/chiclaim/android/downloader/DownloadRequest;)V", "downloader", "Lcom/chiclaim/android/downloader/SystemDownloadManager;", "getDownloader", "()Lcom/chiclaim/android/downloader/SystemDownloadManager;", "downloader$delegate", "Lkotlin/Lazy;", "observer", "Lcom/chiclaim/android/downloader/DownloadObserver;", "download", "", "download$downloader_release", "registerListener", "downloadId", "", "startDownload", "downloader_release"})
public final class SystemDownloader
extends Downloader {
    @Nullable
    private DownloadObserver observer;
    @NotNull
    private final Lazy downloader$delegate;

    public SystemDownloader(@NotNull DownloadRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        super(request);
        this.downloader$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SystemDownloadManager>(request){
            final /* synthetic */ DownloadRequest $request;
            {
                this.$request = $request;
                super(0);
            }

            @NotNull
            public final SystemDownloadManager invoke() {
                return new SystemDownloadManager(this.$request.getContext());
            }
        }));
    }

    private final SystemDownloadManager getDownloader() {
        Lazy lazy = this.downloader$delegate;
        return (SystemDownloadManager)lazy.getValue();
    }

    @Override
    public void startDownload() {
        if (!InstallUtils.checkDownloadComponentEnable(this.getRequest$downloader_release().getContext())) {
            Toast.makeText((Context)this.getRequest$downloader_release().getContext(), (int)R.string.downloader_component_disable, (int)0).show();
            InstallUtils.showDownloadComponentSetting(this.getRequest$downloader_release().getContext());
            return;
        }
        if (this.getRequest$downloader_release().getIgnoreLocal()) {
            this.download$downloader_release();
            return;
        }
        long downloadId = Utils.INSTANCE.getLocalDownloadId(this.getRequest$downloader_release().getContext(), this.getRequest$downloader_release().getUrl());
        if (downloadId != -1L) {
            DownloadInfo downloadInfo = this.getDownloader().getDownloadInfo(downloadId);
            if (downloadInfo == null) {
                this.download$downloader_release();
                return;
            }
            switch (downloadInfo.getStatus()) {
                case 8: {
                    Uri uri = this.getDownloader().getDownloadedFileUri(downloadId);
                    if (uri != null) {
                        String path;
                        String string2 = path = Utils.INSTANCE.getRealPathFromURI(this.getRequest$downloader_release().getContext(), uri);
                        if (string2 != null) {
                            String it = string2;
                            boolean bl = false;
                            File file = new File(it);
                            if (file.exists() && file.length() == downloadInfo.getTotalSize()) {
                                this.getRequest$downloader_release().onComplete$downloader_release(uri);
                                if (this.getRequest$downloader_release().getNeedInstall()) {
                                    InstallUtils.startInstall(this.getRequest$downloader_release().getContext(), file);
                                }
                                return;
                            }
                        }
                    }
                    this.download$downloader_release();
                    break;
                }
                case 2: {
                    this.registerListener(downloadId);
                    break;
                }
                case -1: 
                case 16: {
                    this.download$downloader_release();
                    break;
                }
                default: {
                    DownloadConstants.printDownloadStatus(downloadId, downloadInfo.getStatus());
                    break;
                }
            }
        } else {
            this.download$downloader_release();
        }
    }

    private final void registerListener(long downloadId) {
        DownloadObserver ob;
        if (this.observer != null) {
            return;
        }
        Context context = this.getRequest$downloader_release().getContext().getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"request.context.applicationContext");
        this.observer = ob = new DownloadObserver(context, downloadId, this);
        this.getRequest$downloader_release().getContext().getContentResolver().registerContentObserver(Uri.parse((String)Intrinsics.stringPlus((String)"content://downloads/my_downloads/", (Object)downloadId)), true, (ContentObserver)ob);
    }

    @Override
    public void download$downloader_release() {
        super.download$downloader_release();
        DownloadManager.Request dr = new DownloadManager.Request(Uri.parse((String)this.getRequest$downloader_release().getUrl())).setTitle(this.getRequest$downloader_release().getNotificationTitle()).setDescription(this.getRequest$downloader_release().getNotificationContent()).setNotificationVisibility(this.getRequest$downloader_release().getNotificationVisibility());
        SystemDownloadManager systemDownloadManager = this.getDownloader();
        Intrinsics.checkNotNullExpressionValue((Object)dr, (String)"dr");
        long downloadId = systemDownloadManager.download(dr);
        Utils.INSTANCE.saveDownloadId(this.getRequest$downloader_release().getContext(), this.getRequest$downloader_release().getUrl(), downloadId);
        this.registerListener(downloadId);
    }
}

