/*
 * Decompiled with CFR 0.152.
 */
package com.chiclaim.android.downloader.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import androidx.core.content.FileProvider;
import com.chiclaim.android.downloader.UpgradePermissionDialogActivity;
import com.chiclaim.android.downloader.util.Utils;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\u001a\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\nH\u0002\u001a\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"DOWNLOAD_COMPONENT_PACKAGE", "", "checkDownloadComponentEnable", "", "context", "Landroid/content/Context;", "compare", "uri", "Landroid/net/Uri;", "createInstallIntent", "Landroid/content/Intent;", "apkFile", "Ljava/io/File;", "getApkFileSignature", "Landroid/content/pm/PackageInfo;", "path", "hasInstallPermission", "intentAvailable", "intent", "settingPackageInstall", "", "activity", "Landroid/app/Activity;", "requestCode", "", "showDownloadComponentSetting", "startInstall", "downloader_release"})
@JvmName(name="InstallUtils")
public final class InstallUtils {
    @NotNull
    private static final String DOWNLOAD_COMPONENT_PACKAGE = "com.android.providers.downloads";

    public static final boolean hasInstallPermission(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT >= 26) {
            return context.getPackageManager().canRequestPackageInstalls();
        }
        return true;
    }

    public static final void settingPackageInstall(@NotNull Activity activity, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (Build.VERSION.SDK_INT >= 26) {
            Intent intentSetting = new Intent("android.settings.MANAGE_UNKNOWN_APP_SOURCES", Uri.parse((String)Intrinsics.stringPlus((String)"package:", (Object)activity.getPackageName())));
            activity.startActivityForResult(intentSetting, requestCode);
        }
    }

    @NotNull
    public static final Intent createInstallIntent(@NotNull Context context, @NotNull File apkFile) {
        Uri uri;
        Uri uri2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)apkFile, (String)"apkFile");
        if (Build.VERSION.SDK_INT >= 24) {
            uri2 = FileProvider.getUriForFile((Context)context, (String)Intrinsics.stringPlus((String)context.getPackageName(), (Object)".file.download.fileProvider"), (File)apkFile);
            Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"{\n        FileProvider.g\u2026  apkFile\n        )\n    }");
            uri = uri2;
        } else {
            uri2 = Uri.fromFile((File)apkFile);
            Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"{\n        Uri.fromFile(apkFile)\n    }");
            uri = uri2;
        }
        Uri uri3 = uri;
        return InstallUtils.createInstallIntent(context, uri3);
    }

    @NotNull
    public static final Intent createInstallIntent(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (!InstallUtils.hasInstallPermission(context)) {
            String string2 = uri.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"uri.toString()");
            return UpgradePermissionDialogActivity.Companion.createIntent(context, string2);
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        intent.addFlags(1);
        intent.setDataAndType(uri, "application/vnd.android.package-archive");
        return intent;
    }

    public static final void startInstall(@NotNull Context context, @NotNull File apkFile) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)apkFile, (String)"apkFile");
        context.startActivity(InstallUtils.createInstallIntent(context, apkFile));
    }

    public static final void startInstall(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        context.startActivity(InstallUtils.createInstallIntent(context, uri));
    }

    private static final boolean compare(Context context, Uri uri) {
        String string2 = Utils.INSTANCE.getRealPathFromURI(context, uri);
        if (string2 == null) {
            return false;
        }
        String realFilePath = string2;
        PackageInfo packageInfo = InstallUtils.getApkFileSignature(context, realFilePath);
        if (packageInfo == null) {
            return false;
        }
        PackageInfo apkFileInfo = packageInfo;
        try {
            PackageInfo packageInfo2 = context.getPackageManager().getPackageInfo(context.getPackageName(), 16384);
            if (Intrinsics.areEqual((Object)apkFileInfo.packageName, (Object)packageInfo2.packageName) && apkFileInfo.versionCode > packageInfo2.versionCode) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return true;
        }
        return false;
    }

    private static final PackageInfo getApkFileSignature(Context context, String path) {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        PackageManager pm = context.getPackageManager();
        return Build.VERSION.SDK_INT >= 28 ? pm.getPackageArchiveInfo(path, 0x8000000) : pm.getPackageArchiveInfo(path, 64);
    }

    private static final boolean intentAvailable(Context context, Intent intent) {
        return intent.resolveActivity(context.getPackageManager()) != null;
    }

    public static final void showDownloadComponentSetting(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)"package:com.android.providers.downloads"));
        if (InstallUtils.intentAvailable(context, intent)) {
            context.startActivity(intent);
        }
    }

    public static final boolean checkDownloadComponentEnable(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            int state = context.getPackageManager().getApplicationEnabledSetting(DOWNLOAD_COMPONENT_PACKAGE);
            switch (state) {
                case 2: 
                case 3: 
                case 4: {
                    return false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

