/*
 * Decompiled with CFR 0.152.
 */
package com.chiclaim.android.downloader.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkRequest;
import com.chiclaim.android.downloader.util.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/chiclaim/android/downloader/util/NetworkHelper;", "", "()V", "registerNetworkCallback", "", "context", "Landroid/content/Context;", "downloader_release"})
public final class NetworkHelper {
    @NotNull
    public static final NetworkHelper INSTANCE = new NetworkHelper();

    private NetworkHelper() {
    }

    public final void registerNetworkCallback(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getApplicationContext().getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)object;
        NetworkRequest request = new NetworkRequest.Builder().addCapability(12).build();
        connectivityManager.registerNetworkCallback(request, new ConnectivityManager.NetworkCallback(){

            public void onAvailable(@NotNull Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                super.onAvailable(network);
                Logger.e(Intrinsics.stringPlus((String)"onAvailable:", (Object)Thread.currentThread().getName()));
            }

            public void onLost(@NotNull Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                super.onLost(network);
                Logger.e(Intrinsics.stringPlus((String)"onLost:", (Object)Thread.currentThread().getName()));
            }
        });
    }
}

