/*
 * Decompiled with CFR 0.152.
 */
package com.chiclaim.android.downloader.util;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.annotation.DrawableRes;
import androidx.core.app.NotificationCompat;
import com.chiclaim.android.downloader.R;
import com.chiclaim.android.downloader.util.InstallUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/chiclaim/android/downloader/util/NotifierUtils;", "", "()V", "Companion", "downloader_release"})
public final class NotifierUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String CHANNEL_ID = "download_channel_normal";

    private NotifierUtils() {
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\r\u001a\u00020\nH\u0002JZ\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\n2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/chiclaim/android/downloader/util/NotifierUtils$Companion;", "", "()V", "CHANNEL_ID", "", "cancelNotification", "", "context", "Landroid/content/Context;", "id", "", "getNotificationManager", "Landroid/app/NotificationManager;", "getPendingIntentFlag", "showNotification", "notifierSmallIcon", "percent", "title", "", "content", "status", "file", "Ljava/io/File;", "url", "downloader_release"})
    public static final class Companion {
        private Companion() {
        }

        private final int getPendingIntentFlag() {
            return Build.VERSION.SDK_INT >= 23 ? 0xC000000 : 0x8000000;
        }

        private final NotificationManager getNotificationManager(Context context) {
            Object object = context.getApplicationContext().getSystemService("notification");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.NotificationManager");
            }
            return (NotificationManager)object;
        }

        public final void showNotification(@NotNull Context context, int id2, @DrawableRes int notifierSmallIcon, int percent, @NotNull CharSequence title, @Nullable CharSequence content, int status, @Nullable File file, @Nullable String url) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            NotificationManager notificationManager = this.getNotificationManager(context);
            if (Build.VERSION.SDK_INT >= 26) {
                NotificationChannel channel = new NotificationChannel(NotifierUtils.CHANNEL_ID, (CharSequence)context.getString(R.string.downloader_notifier_channel_name), 2);
                notificationManager.createNotificationChannel(channel);
            }
            NotificationCompat.Builder builder = new NotificationCompat.Builder(context, NotifierUtils.CHANNEL_ID).setSmallIcon(notifierSmallIcon).setContentTitle(title).setAutoCancel(status == 8).setOngoing(percent != 100);
            if (percent >= 0) {
                Object[] objectArray = new Object[]{percent};
                builder.setSubText((CharSequence)context.getString(R.string.downloader_notifier_subtext_placeholder, objectArray));
            }
            switch (status) {
                case 8: {
                    File file2 = file;
                    if (file2 == null) break;
                    File it = file2;
                    boolean bl = false;
                    Intent clickIntent = InstallUtils.createInstallIntent(context, it);
                    PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)clickIntent, (int)Companion.getPendingIntentFlag());
                    builder.setContentIntent(pendingIntent);
                    break;
                }
                case 2: {
                    builder.setProgress(100, percent, percent <= 0);
                    break;
                }
                case 16: {
                    Intent intent = new Intent(Intrinsics.stringPlus((String)context.getPackageName(), (Object)".file.download.DownloadService"));
                    intent.setPackage(context.getPackageName());
                    intent.putExtra("url", url);
                    intent.putExtra("from", 2);
                    PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)1, (Intent)intent, (int)this.getPendingIntentFlag());
                    builder.setContentIntent(pendingIntent);
                }
            }
            CharSequence charSequence = content;
            if (charSequence != null) {
                CharSequence it = charSequence;
                boolean bl = false;
                builder.setContentText(it);
            }
            notificationManager.notify(id2, builder.build());
        }

        public static /* synthetic */ void showNotification$default(Companion companion, Context context, int n, int n2, int n3, CharSequence charSequence, CharSequence charSequence2, int n4, File file, String string2, int n5, Object object) {
            if ((n5 & 0x80) != 0) {
                file = null;
            }
            if ((n5 & 0x100) != 0) {
                string2 = null;
            }
            companion.showNotification(context, n, n2, n3, charSequence, charSequence2, n4, file, string2);
        }

        public final void cancelNotification(@NotNull Context context, int id2) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.getNotificationManager(context).cancel(id2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

