/*
 * Decompiled with CFR 0.152.
 */
package com.chiclaim.android.downloader.util;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.widget.Toast;
import androidx.core.app.NotificationManagerCompat;
import com.chiclaim.android.downloader.DownloadException;
import com.chiclaim.android.downloader.R;
import com.chiclaim.android.downloader.util.MD5;
import com.chiclaim.android.downloader.util.SpHelper;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u001d\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0011J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017J&\u0010\u0018\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000e2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0002J\u001e\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\nJ$\u0010 \u001a\u0004\u0018\u0001H!\"\u0006\b\u0000\u0010!\u0018\u0001*\u00020\u001a2\u0006\u0010\"\u001a\u00020\fH\u0086\b\u00a2\u0006\u0002\u0010#\u00a8\u0006$"}, d2={"Lcom/chiclaim/android/downloader/util/Utils;", "", "()V", "checkNotificationsEnabled", "", "context", "Landroid/content/Context;", "getDownloadDir", "Ljava/io/File;", "getLocalDownloadId", "", "url", "", "getPercent", "", "totalSize", "downloadedSize", "getPercent$downloader_release", "getRealPathFromURI", "contentURI", "Landroid/net/Uri;", "getTipFromException", "exception", "", "getValueByType", "cursor", "Landroid/database/Cursor;", "index", "klass", "Ljava/lang/Class;", "saveDownloadId", "id", "getValue", "T", "column", "(Landroid/database/Cursor;Ljava/lang/String;)Ljava/lang/Object;", "downloader_release"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    public final long getLocalDownloadId(@NotNull Context context, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return SpHelper.Companion.get(context).getLong(Intrinsics.stringPlus((String)MD5.INSTANCE.md5(url), (Object)"-id"), -1L);
    }

    public final void saveDownloadId(@NotNull Context context, @NotNull String url, long id2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        SpHelper.Companion.get(context).putLong(Intrinsics.stringPlus((String)MD5.INSTANCE.md5(url), (Object)"-id"), id2);
    }

    public final /* synthetic */ <T> T getValue(Cursor $this$getValue, String column) {
        Intrinsics.checkNotNullParameter((Object)$this$getValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        boolean $i$f$getValue = false;
        int index = $this$getValue.getColumnIndex(column);
        if (index == -1) {
            return null;
        }
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Object object = this.getValueByType($this$getValue, index, Object.class);
        Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
        return (T)object;
    }

    private final Object getValueByType(Cursor cursor, int index, Class<?> klass) {
        Class<?> clazz = klass;
        return Intrinsics.areEqual(clazz, String.class) ? (Serializable)((Object)cursor.getString(index)) : (Intrinsics.areEqual(clazz, Long.class) ? (Serializable)Long.valueOf(cursor.getLong(index)) : (Intrinsics.areEqual(clazz, Integer.class) ? (Serializable)Integer.valueOf(cursor.getInt(index)) : (Intrinsics.areEqual(clazz, Short.class) ? (Serializable)Short.valueOf(cursor.getShort(index)) : (Intrinsics.areEqual(clazz, Float.class) ? (Serializable)Float.valueOf(cursor.getFloat(index)) : (Intrinsics.areEqual(clazz, Double.class) ? (Serializable)Double.valueOf(cursor.getDouble(index)) : (Intrinsics.areEqual(clazz, Boolean.class) ? (Serializable)Boolean.valueOf(cursor.getInt(index) != 0) : (Intrinsics.areEqual(clazz, byte[].class) ? (Serializable)cursor.getBlob(index) : null)))))));
    }

    public final int getPercent$downloader_release(long totalSize, long downloadedSize) {
        return totalSize <= 0L ? 0 : (int)((double)downloadedSize / (double)totalSize * (double)100);
    }

    @NotNull
    public final File getDownloadDir(@NotNull Context context) {
        File dir;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File file = dir = context.getExternalCacheDir();
        if (file == null ? false : file.isDirectory()) {
            return dir;
        }
        File file2 = context.getFilesDir();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"context.filesDir");
        return file2;
    }

    public final void checkNotificationsEnabled(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!NotificationManagerCompat.from((Context)context).areNotificationsEnabled()) {
            Toast.makeText((Context)context, (int)R.string.downloader_notification_disable, (int)0).show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String getRealPathFromURI(@NotNull Context context, @NotNull Uri contentURI) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)contentURI, (String)"contentURI");
        if (Build.VERSION.SDK_INT >= 24) {
            Cursor cursor;
            Cursor cursor2 = cursor = context.getContentResolver().query(contentURI, null, null, null, null);
            if (cursor2 != null) {
                Closeable closeable = (Closeable)cursor2;
                Throwable throwable = null;
                try {
                    Cursor it = (Cursor)closeable;
                    boolean bl = false;
                    cursor.moveToFirst();
                    int index = cursor.getColumnIndex("_data");
                    if (index != -1) {
                        String string2 = cursor.getString(index);
                        return string2;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        } else {
            return contentURI.getPath();
        }
        return null;
    }

    @NotNull
    public final String getTipFromException(@NotNull Context context, @NotNull Throwable exception) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        if (exception instanceof DownloadException) {
            String string3;
            switch (((DownloadException)exception).getErrorType()) {
                case 1: {
                    String string4 = context.getString(R.string.downloader_notifier_content_without_network);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"context.getString(R.stri\u2026_content_without_network)");
                    string3 = string4;
                    break;
                }
                case 6: {
                    String string5 = context.getString(R.string.downloader_notifier_content_partial_error);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"context.getString(R.stri\u2026er_content_partial_error)");
                    string3 = string5;
                    break;
                }
                case 5: {
                    String string6 = context.getString(R.string.downloader_notifier_content_too_many_redirects);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"context.getString(R.stri\u2026ntent_too_many_redirects)");
                    string3 = string6;
                    break;
                }
                case 7: {
                    String string7 = context.getString(R.string.downloader_notifier_content_missing_location);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"context.getString(R.stri\u2026content_missing_location)");
                    string3 = string7;
                    break;
                }
                default: {
                    Object[] objectArray = new Object[]{((DownloadException)exception).getResponseCode()};
                    String string8 = context.getString(R.string.downloader_notifier_content_unhandled_err, objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"context.getString(\n     \u2026ode\n                    )");
                    string3 = string8;
                }
            }
            return string3;
        }
        Throwable throwable = exception;
        if (throwable instanceof SocketTimeoutException) {
            String string9 = context.getString(R.string.downloader_notifier_content_network_timeout);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"context.getString(R.stri\u2026_content_network_timeout)");
            string2 = string9;
        } else if (throwable instanceof SocketException) {
            String string10 = context.getString(R.string.downloader_notifier_content_without_network);
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"context.getString(R.stri\u2026_content_without_network)");
            string2 = string10;
        } else if (throwable instanceof ConnectException) {
            String string11 = context.getString(R.string.downloader_notifier_content_without_network);
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"context.getString(R.stri\u2026_content_without_network)");
            string2 = string11;
        } else if (throwable instanceof UnknownHostException) {
            String string12 = context.getString(R.string.downloader_notifier_content_without_network);
            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"context.getString(R.stri\u2026_content_without_network)");
            string2 = string12;
        } else {
            Object[] objectArray = new Object[1];
            String string13 = exception.getMessage();
            if (string13 == null) {
                String string14 = exception.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"exception::class.java.name");
                string13 = string14;
            }
            objectArray[0] = string13;
            String string15 = context.getString(R.string.downloader_notifier_content_err_placeholder, objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"context.getString(\n     \u2026va.name\n                )");
            string2 = string15;
        }
        return string2;
    }
}

