/*
 * Decompiled with CFR 0.152.
 */
package com.chiclaim.android.downloader.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ScrollView;
import com.chiclaim.android.downloader.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\f\u001a\u00020\tH\u0002J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0014J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\tR\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/chiclaim/android/downloader/widget/MaxHeightScrollView;", "Landroid/widget/ScrollView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "maxHeight", "defaultMaxHeight", "initAttrs", "", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "setMaxHeight", "downloader_release"})
public final class MaxHeightScrollView
extends ScrollView {
    private int maxHeight;

    public MaxHeightScrollView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.maxHeight = -1;
        this.initAttrs(null);
    }

    public MaxHeightScrollView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.maxHeight = -1;
        this.initAttrs(attrs);
    }

    public MaxHeightScrollView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.maxHeight = -1;
        this.initAttrs(attrs);
    }

    private final int defaultMaxHeight() {
        return this.getContext().getResources().getDisplayMetrics().heightPixels / 2;
    }

    public final void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    private final void initAttrs(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray attr = this.getContext().obtainStyledAttributes(attrs, R.styleable.MaxHeightScrollView);
            this.maxHeight = attr.getDimensionPixelSize(R.styleable.MaxHeightScrollView_maxHeight, -1);
            attr.recycle();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.maxHeight == -1) {
            this.maxHeight = this.defaultMaxHeight();
        }
        int newHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.maxHeight, (int)Integer.MIN_VALUE);
        super.onMeasure(widthMeasureSpec, newHeightMeasureSpec);
    }
}

