/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.cires.cmg.mvt.adapt.jts;

import edu.colorado.cires.cmg.mvt.VectorTile;
import edu.colorado.cires.cmg.mvt.adapt.jts.IUserDataConverter;
import edu.colorado.cires.cmg.mvt.build.MvtLayerProps;
import edu.colorado.cires.cmg.mvt.util.JdkUtils;
import java.util.Map;
import org.slf4j.LoggerFactory;

public final class UserDataKeyValueMapConverter
implements IUserDataConverter {
    private final boolean setId;
    private final String idKey;

    public UserDataKeyValueMapConverter() {
        this.setId = false;
        this.idKey = null;
    }

    public UserDataKeyValueMapConverter(String idKey) {
        JdkUtils.requireNonNull(idKey);
        this.setId = true;
        this.idKey = idKey;
    }

    @Override
    public void addTags(Object userData, MvtLayerProps layerProps, VectorTile.Tile.Feature.Builder featureBuilder) {
        if (userData != null) {
            try {
                Object idValue;
                Map userDataMap = (Map)userData;
                for (Map.Entry e : userDataMap.entrySet()) {
                    int valueIndex;
                    String key = (String)e.getKey();
                    Object value = e.getValue();
                    if (key == null || value == null || (valueIndex = layerProps.addValue(value)) < 0) continue;
                    featureBuilder.addTags(layerProps.addKey(key));
                    featureBuilder.addTags(valueIndex);
                }
                if (this.setId && (idValue = userDataMap.get(this.idKey)) != null) {
                    if (idValue instanceof Long || idValue instanceof Integer || idValue instanceof Float || idValue instanceof Double || idValue instanceof Byte || idValue instanceof Short) {
                        featureBuilder.setId((Long)idValue);
                    } else if (idValue instanceof String) {
                        try {
                            featureBuilder.setId(Long.parseLong((String)idValue));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
            }
            catch (ClassCastException e) {
                LoggerFactory.getLogger(UserDataKeyValueMapConverter.class).error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

